package config;

import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import util.DBF;
import util.FF;
import webApp.App;

import java.sql.Connection;
import java.util.concurrent.ConcurrentHashMap;

public class CacheCustomProperty
{

    public static ConcurrentHashMap<String ,String> config = new ConcurrentHashMap<>();

    public static void  reloadConfig()
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;
        try
        {
            FF.log(App.getInstance().getVirtualHostName()+ "重新调取自定义属性开始");
            long d=System.currentTimeMillis();
            con=dbf.getConnection();
            DataStore ds= DataStoreFactory.newDataStore(con,"select fullname , value ,metadata  from app_customproperty where nodetype in ('leaf','column')");
            int n=  ds.retrieve();
            for(int i=0;i<n;i++)
            {
                String key= ds.getString(i,"fullname");
                String value= ds.getString(i,"value");
                String value2= ds.getString(i,"metadata");

                config.put(key+":product" , value);
                config.put(key+":test" , value2);

            }

            FF.log(App.getInstance().getVirtualHostName()+ "重新调取自定义属性完成，耗时"+((System.currentTimeMillis()-d)/1000)+"秒");

        } catch (Exception e)
        {

        } finally
        {
            dbf.releaseConnection(con);
        }

    }

    public static   String  get(String fullname , String defaultValue)
    {
        fullname+=":"+ CacheConfig.get("/运行环境/运行环境","product");

        if( config.containsKey(fullname)) return config.get(fullname);
        return defaultValue;
    }

    public static int  get(String fullnanme , int defaultValue)
    {

        String v= get(fullnanme,""+defaultValue);
        return FF.String2Int(v);
    }

    public static boolean get(String fullname , boolean defaultValue)
    {
        String v=get(fullname, String.valueOf(defaultValue));
        if( v.equalsIgnoreCase("true")) return true;
        if( v.equals("1")) return true;
        if( v.equalsIgnoreCase("y")) return true;
        if( v.equalsIgnoreCase("yes")) return true;
        if( v.equalsIgnoreCase("t")) return true;

        return false;

    }
}
