package config;

import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import util.DBF;
import util.FF;
import webApp.App;
import websocketRPC.WSRPC;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class CacheConfig
{

    //不要有数据库的操作，
    public static ConcurrentHashMap<String ,String> config = new ConcurrentHashMap<>();
    public static final String  key_csp_script_src_third ="$csp_script_src_third$";
    public static final String  key_third_script_link = "$third_script_link$";
    public static final String key_content_security_policy ="Content-Security-Policy";

    public static  long  lastModifiedDate=0;

    // api注入设置
    public   static  volatile  boolean  apiInjectEnable= false;

    public static ConcurrentHashMap<String ,String>  apiInjectConfig = new ConcurrentHashMap<>();

    public static void  reloadConfig(  )
    {
        reloadConfig(100);
    }
    public static void  reloadConfig( int maxTryTimes)
    {


        JSONObject ret=new JSONObject();

        int tryCount=0;
        while(true)
        {
            ret= WSRPC.dispatch("config","service.AppConfig","getAppConfig" ,
                           new JSONObject().put("service", App.appName), null, null, false);
            if( ret.getBoolean("success",false)) break;
            FF.log("获取系统设置未果，"+ret.getString("message",""));


            tryCount++;
            if( tryCount >=maxTryTimes)
            {
                FF.log("CacheConfig.reloadConfig 在尝试"+tryCount+"后仍未成功，放弃尝试。系统设置加载失败");
                break;
            }
            FF.sleep(5000);
            FF.log("5秒后重新尝试。");
        }


        JSONObject data= ret.getJSONObject("data",new JSONObject());
        Iterator<String> it= data.keys();
        while( it.hasNext())
        {
            String key= it.next();
            String value= data.getString(key,"");
            config.put(key , value);
        }

        //2023.12.19 增加DataStore密码初始化
        String pwd= FF.readFile( App.FileRoot+"/dbencrypt.txt");
        pwd= FF.decryptString(pwd, "z038e4vr");
        DataStoreFactory.setDESKey(pwd);

        //2020.06.04 很怪， 下面两条之前居然没加上， 这表示 form中的 csp设置没能加载 ，现在加上了
        build_csp_script_src_third();
        build_csp();

        build_apiInjectConfig();

        lastModifiedDate= System.currentTimeMillis();
    }


    /**
     * 系统注入点的配置
     */
    public static void build_apiInjectConfig()
    {
        apiInjectEnable = CacheConfig.get("/系统配置/系统切入/inject", "").equalsIgnoreCase("true");

        apiInjectConfig.clear();

        if(! apiInjectEnable) return;

        String  t = CacheConfig.get("/系统配置/系统切入/api2script", "[]");
        JSONArray  ja= new JSONArray(t);

        for( int i=0;i< ja.length();i++)
        {
            JSONObject one= ja.getJSONObject(i);
            if( one==null) continue;
            String service=  one.getString("service","");
            String classAndMethod=  one.getString("api","");
            String when=  one.getString("when","");
            String script= one.getString("script","");
            if( script.isEmpty()) continue;

            String key= service+"."+classAndMethod+"."+when;
            apiInjectConfig.put( key , script);
        }

    }


    //预先准备好，不要每次打开时再准备
    public static void   build_csp_script_src_third()
    {
        String scriptSrc = CacheConfig.get("/CSP/模板全局脚本扩展/scriptsrc", "");
        String csp_script_src_third = "";

            scriptSrc = FF.replaceAll(scriptSrc, " ", "");
            scriptSrc = FF.replaceAll(scriptSrc, "\r", "");
            String[] s = scriptSrc.split("\n");
            StringBuffer scriptSrcBuffer = new StringBuffer();
            for (int i = 0; i < s.length; i++)
            {
                if (s[i].trim().isEmpty()) continue;
                scriptSrcBuffer.append("<script src=\"" + s[i] + "\"></script>\n");
                int p = s[i].indexOf("/", 9);
                if (p > 0) s[i] = s[i].substring(0, p);
                if (csp_script_src_third.indexOf(s[i]) < 0) csp_script_src_third += " " + s[i];
            }

            config.put( key_csp_script_src_third , csp_script_src_third);
            config.put( key_third_script_link ,   scriptSrcBuffer.toString());


    }

    public static void build_csp()
    {
        //CSP设置
        String csp_script_src =  CacheConfig.get(key_csp_script_src_third ,"")+ " " + CacheConfig.get("/CSP/Content-Security-Policy/script_src", "");
        String csp_connect_src= CacheConfig.get("/CSP/Content-Security-Policy/connect_src", "");
        String csp_style_src= CacheConfig.get("/CSP/Content-Security-Policy/style_src", "");
        String csp_media_src= CacheConfig.get("/CSP/Content-Security-Policy/media_src", "");
        String csp_font_src= CacheConfig.get("/CSP/Content-Security-Policy/font_src", "");
        String csp_img_src= CacheConfig.get("/CSP/Content-Security-Policy/img_src", "");
        String csp_frame_ancestors= CacheConfig.get("/CSP/Content-Security-Policy/frame_ancestors", "");
        String csp_worker_src= CacheConfig.get("/CSP/Content-Security-Policy/worker_src", "");
        String csp_manifest_src= CacheConfig.get("/CSP/Content-Security-Policy/manifest_src", "");

        /*
        <!--
            img-src 直接开放所有

        connect-src 不加 * 则本机也不能连接，原因待查，先用*开放所有
            -->

            */

        String source="";
        try
        {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("CSP.txt");
            source = FF.readFromStream(is);
            is.close();
        }catch(Exception e)
        {

        }

        source= source.replace("${csp_script_src}" , csp_script_src);
        source= source.replace("${csp_connect_src}" , csp_connect_src);
        source= source.replace("${csp_style_src}" ,csp_style_src );
        source= source.replace("${csp_media_src}" ,csp_media_src );
        source= source.replace("${csp_font_src}" ,csp_font_src );
        source= source.replace("${csp_img_src}" ,csp_img_src );
        source= source.replace("${csp_frame_ancestors}" , csp_frame_ancestors);
        source= source.replace("${csp_worker_src}" , csp_worker_src);
        source= source.replace("${csp_manifest_src}" ,csp_manifest_src );


        config.put(key_content_security_policy , source);


    }

    //如果内容明显较少，那么重新加载
    private  static void   validCheck()
    {
        if( config.size()<200)  reloadConfig(1);
    }

    public static   String  get(String fullname , String defaultValue)
    {

        if( config.containsKey(fullname)) return config.get(fullname);
        return defaultValue;
    }

    public static int  get(String fullnanme , int defaultValue)
    {

        String v= get(fullnanme,""+defaultValue);
        return FF.String2Int(v);
    }

    public static long  get(String fullnanme , long defaultValue)
    {
        String v= get(fullnanme,""+defaultValue);
        return FF.String2Long(v);
    }

    public static boolean get(String fullname , boolean defaultValue)
    {
        String v=get(fullname, String.valueOf(defaultValue));
        if( v.equalsIgnoreCase("true")) return true;
        if( v.equals("1")) return true;
        if( v.equalsIgnoreCase("y")) return true;
        if( v.equalsIgnoreCase("yes")) return true;
        if( v.equalsIgnoreCase("t")) return true;

        return false;

    }


    public static boolean  isMultiCorporationEnabled()
    {
        return CacheConfig.get("/系统配置/启用多租户支持/enabled", "false").equalsIgnoreCase("true");
    }
}
