package cms;

import config.CacheConfig;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import util.AppCache;
import util.FF;
import util.FormCache;
import websocketRPC.WSRPC;

import java.util.ArrayList;
import java.util.List;

public class CMSCache
{
    public static String CS_NEWCACHE_PREFIX = "cmc-cache:news:";

    public static String CS_SUBJECT_PREFIX = "CMS:subject:";
    public static String CS_SUBJECT_LASTMODIFIEDDATE_PREFIX = "CMS:subjectLastModifiedDate:";

    public static String CS_SUBJECT_ADMIN_PREFIX = "CMS:subjectAdmin:";


    //不考虑多企业
    public static String getPoolNameForNews()
    {
        String dbpool = CacheConfig.get("/系统配置/CMS内容管理/dbpool", "");
        return dbpool;
    }

    public static String getSubjectid4News(String newsid)
    {
        String key = CS_NEWCACHE_PREFIX + "subjectid4news:" + newsid;
        String ret = AppCache.getCache(key, "");
        if (ret.isEmpty())
        {
            ret = FF.getStringFromSQL(getPoolNameForNews(), "select subjectid from app_news where id= " + newsid  );
            if (ret.isEmpty()) return   "null";
            AppCache.setCache(key, ret, true, 2 * 24 * 60 * 60);
        }
        return ret;
    }

    /**
     * 获取新闻的缓存
     *
     * @param id
     * @return
     */
    public static String getNewsInfo(String id)
    {
        String key = CS_NEWCACHE_PREFIX + id;
        String ret = AppCache.getCache(key, "");
        if (ret.isEmpty())
        {

            DataStore ds = DataStoreFactory.newDataStore(getPoolNameForNews(), "select * from app_news where id='" + id + "'");
            ds.retrieve();
            if (ds.getRowCount() == 1)
            {
                ret = ds.getJSON(0, true, false, false, true).toString();
                AppCache.setCache(key, ret, true, 7 * 24 * 60 * 60);
            }
        }
        return ret;
    }

    /**
     * 清理缓存，并重新缓存新闻
     *
     * @param id
     */
    public static void rebuildNewsCache(String id)
    {
        String key = CS_NEWCACHE_PREFIX + id;
        AppCache.removeCache(key);
        getNewsInfo(id);
    }


    public static void rebuildSubjectCache(String subjectid)
    {
        WSRPC.dispatch("cache", "api.CacheRefresh", "refresh_cache_subject",
                       new JSONObject().put("where", "id='" + subjectid + "'"), FF.EHR, null);
    }

    public static String subjectid2name(String subjectid)
    {
        String t = AppCache.getCache(CS_SUBJECT_PREFIX + subjectid, "");
        if (!t.isEmpty())
        {
            JSONObject js = new JSONObject(t);
            t = js.getString("name", "");
        }

        if (t.isEmpty()) t = FF.getStringFromSQL("", "select name from app_subject where id='" + subjectid + "'");
        return t;

    }

    public static String getSubjectConfig(String subjectid)
    {
        String ret = AppCache.getCache(CS_SUBJECT_PREFIX + subjectid, "{}");
        return ret;
    }

    public static boolean isSubjectManager(int userid, String subjectid)
    {
        return !FF.getStringFromSQL("", "select id from app_subject_manager where userid=" + userid + " and subjectid='" + subjectid + "'").isEmpty();
    }

    public static List<Integer> getSubjectAdminList(String subjectid)
    {
        List<Integer> ret = new ArrayList<>();

        DataStore ds = DataStoreFactory.newDataStore("", "select userid from app_subject_manager where subjectid='" + subjectid + "'");
        int n = ds.retrieve();
        for (int i = 0; i < n; i++)
        {
            ret.add(ds.getInt(i, "userid"));
        }
        return ret;
    }

    public static String getSubjectListTemplate(String subjectid)
    {
        String t = FF.getStringFromSQL("", "select  value from app_subject where namne='template_list' and pid='" + subjectid + "'  ");
        if (t.isEmpty()) t = CacheConfig.get("/系统配置/CMS内容管理/template_list", "");
        return t;
    }

    public static String getSubjectEditTemplate(String subjectid)
    {
        String t = FF.getStringFromSQL("", "select  value from app_subject where namne='template_edit' and pid='" + subjectid + "'  ");

        if (t.isEmpty()) t = CacheConfig.get("/系统配置/CMS内容管理/template_edit", "");
        return t;
    }


    public static JSONObject getDatalistConfig(String subjectid, String datalist)
    {
        JSONArray ja = FF.getJSONArrayFromSQL("", "select  * from app_subject_list where subjectid='" + subjectid + "' and name='" + datalist + "' ");
        if (ja.length() > 0) return ja.getJSONObject(0);
        return new JSONObject();

    }

    public static JSONObject getRenderConfig(String renderid)
    {

        String sql = " select  id, name ,  metadata as mbtype , value as html  from app_subject_render where  nodetype='leaf' and  id ='" + renderid + "'";

        JSONArray ja = FF.getJSONArrayFromSQL("", sql);
        if (ja.length() > 0) return ja.getJSONObject(0);
        return new JSONObject();

    }

    public static String getRealSubjectId(String subjectid)
    {
        return new JSONObject(getSubjectConfig(subjectid)).getString("id", "");
    }


    /**
     * 当新闻的审核状态，标题，阅读数量点赞数量发生变化时，需要刷新新闻所在栏目的清单
     *
     * @param newsid
     * @param subjectid
     */
    public static void newBuildCMSDataListCacheTask_WhenNewsChange(  String subjectid)
    {
        JSONArray ja = getAllCMSDataListConfig();
        JSONArray tasks = new JSONArray();
        for (int i = 0; i < ja.length(); i++)
        {
            String t = ja.getString(i);
            String[] s = t.split(";");

            if (s[0].equals("url") || s[0].equals(subjectid))
            {
                tasks.put(subjectid + ";" + s[1] + ";" + s[2]);
            }
        }

        WSRPC.dispatch("cms", "api.DataListHTMLBuilder", "newBuildCMSDataListCacheTask",
                       new JSONObject().put("tasks", tasks), FF.EHR, null, false);
    }


    /**
     * 当栏目的数据清单配置变化后， 更新缓存
     * @param subjectid
     * @param datalist
     */
    public static void newBuildCMSDataListCacheTask_WhenSubjectDataListConfigChanged(String subjectid, String datalist)
    {
        JSONArray ja = getAllCMSDataListConfig();
        JSONArray tasks = new JSONArray();
        for (int i = 0; i < ja.length(); i++)
        {
            String t = ja.getString(i);
            String[] s = t.split(";");

            if (   s[0].equals(subjectid) && s[1].equals(datalist))
            {
                tasks.put(subjectid + ";" + s[1] + ";" + s[2]);
            }
        }

        WSRPC.dispatch("cms", "api.DataListHTMLBuilder", "newBuildCMSDataListCacheTask",
                       new JSONObject().put("tasks", tasks), FF.EHR, null, false);
    }

    /**
     * 当渲染模板变化后， 所有使用它渲染的清单缓存都要刷新
     * @param renderid
     */
    public static void newBuildCMSDataListCacheTask_WhenRenderConfigChanged(String renderid )
    {
        JSONArray ja = getAllCMSDataListConfig();
        JSONArray tasks = new JSONArray();
        for (int i = 0; i < ja.length(); i++)
        {
            String t = ja.getString(i);
            String[] s = t.split(";");

            if ( s[2].equals(renderid))
            {
                if( s[0].equals("url"))
                {
                    String datalist=s[1];
                    JSONArray  subjects= FF.getJSONArrayFromSQL("",  "select  subjectid  from app_subject_list  where name='"+datalist+"' " );
                    for( int j=0;j<subjects.length();j++)
                    {
                        tasks.put( subjects.getJSONObject(j).getString("subjectid","")+";"+s[1]+";"+s[2] );
                    }
                }else
                {
                    tasks.put(t  );
                }
            }
        }

        WSRPC.dispatch("cms", "api.DataListHTMLBuilder", "newBuildCMSDataListCacheTask",
                       new JSONObject().put("tasks", tasks), FF.EHR, null, false);
    }

    /**
     * 得到所有的模板中使用到的数据清单配置
     * @return
     */
    public static JSONArray  getAllCMSDataListConfig()
    {
        JSONArray ret= new JSONArray();
        JSONArray ja=FF.getJSONArrayFromSQL("", "select value from app_template where name='cmsDataListConfig' and nodetype='column'");
        for(int i=0;i<ja.length();i++)
        {
            String t= ja.getJSONObject(i).getString("value","");
            JSONArray ja2= new JSONArray(t);
            for(int j=0;j<ja2.length();j++)
            {
                ret.put( ja2.getString(j));
            }
        }
        return ret;

    }
}
