package cache;


import jun.db.util.Base64Coder;
import org.ehcache.Cache;
import org.ehcache.PersistentCacheManager;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.ehcache.impl.internal.statistics.DefaultStatisticsService;
import org.json.JSONArray;
import org.json.JSONObject;
import util.DateTool;
import util.FF;

import java.io.File;
import java.util.*;
import java.util.concurrent.TimeUnit;

public class ZCache implements ICache
{


    public StatisticsService statisticsService;
    public PersistentCacheManager persistentCacheManager;

    public Cache<String, String> cache;
    public static DateTool  DT= new DateTool();
    private static String DATEFORMAT="yyyy.MM.dd HH:mm:ss";


    public ZCache(String cacheName, long maxElementsInMemory, long offHeapSize, long diskSpoolBufferSizeMB, String cachePath, String cacheFileName,
                  long timeToIdleSeconds, long timeToLiveSeconds, boolean persistent)
    {

        // timeToLiveSeconds的定义是：以创建时间为基准开始计算的超时时长；

        // timeToIdleSeconds的定义是：在创建时间和最近访问时间中取出离现在最近的时间作为基准计算的超时时长；
        FF.log("磁盘缓存目录：" + cachePath);
        statisticsService = new DefaultStatisticsService();
        FF.log("创建目录：" + cachePath);
        FF.MkDirs(cachePath);


        persistentCacheManager = CacheManagerBuilder.newCacheManagerBuilder()
                .with(CacheManagerBuilder.persistence(cachePath + File.separatorChar + cacheFileName))
                .withCache(cacheName,
                           CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, String.class,
                                                                                  ResourcePoolsBuilder.newResourcePoolsBuilder()
                                                                                          .heap(maxElementsInMemory, EntryUnit.ENTRIES)
                                                                                          .offheap(offHeapSize, MemoryUnit.MB)
                                                                                          .disk(diskSpoolBufferSizeMB, MemoryUnit.MB, persistent))
                                   .withExpiry(timeToIdleSeconds == 0 ?
                                                       Expirations.noExpiration()
                                                       : Expirations.timeToIdleExpiration(Duration.of(timeToIdleSeconds, TimeUnit.SECONDS)))
                                   .withExpiry(timeToLiveSeconds == 0 ?
                                                       Expirations.noExpiration()
                                                       : Expirations.timeToLiveExpiration(Duration.of(timeToLiveSeconds, TimeUnit.SECONDS))))
                .using(statisticsService)
                .build(true);


        cache = persistentCacheManager.getCache(cacheName, String.class, String.class);


        FF.log("缓存开启成功");
    }

    public void put(String key, String value)
    {
        cache.put(key, value);

    }

    //带有效期的， 由于EhCache 不能在元素上定义有效期，所以只以自已hacker ,在数据前拼一个过期时间
    public void put(String key, int second, String value)
    {
        if( second==0)
        {
            put( key , value);
            return;
        }

        Date d= new Date();
        d= DT.nextDate(d , second,"second");

        value="validbefore"+  FF.date2String(d ,DATEFORMAT)  +"/"+value;
        cache.put(key, value);

    }

    public boolean exists(String key)
    {
        return cache.containsKey(key);
    }

    @Override
    public JSONObject get(JSONArray keys)
    {
        JSONObject ret= new JSONObject();
        for( int i=0;i<keys.length();i++)
        {
            String key= keys.getString(i);
            String value= get( key, null);
            if( value==null) continue;;
            ret.put( key, value);

        }
        return ret;
    }

    public String get(String key, String defaultValue)
    {
        if (cache.containsKey(key))
        {
            String ret = cache.get(key);
            if( key.startsWith("session")  ||  ret.startsWith("validbefore"))
            {
                String t= ret.substring(11,   ret.indexOf("/"));
                //2020/10/27 去掉值前面的有效时间标记， 之前为什么没有去掉，清楚，但是不去掉，数据就多了一个头
                ret= ret.substring(ret.indexOf("/")+1);
                Date d=   DT.string2Date(t , DATEFORMAT);
                if( d==null)  d= new Date();
                //过期了
                if( DT.isBeforeDate( d , new Date()))
                {
                    ret=null;
                    remove(key);
                }else
                {

                }

            }


            if (ret == null) ret = defaultValue;
            return ret;
        }
        return defaultValue;
    }

    public JSONObject  getMatch(String key)
    {
        JSONObject ret= new JSONObject();

        Iterator <org.ehcache.Cache.Entry<String,String>> it = cache.iterator();
        while (it.hasNext())
        {

            String  tk=it.next().getKey();
            if( tk.startsWith(key))  ret.put(tk ,  get(key,"") );
        }

        return ret;
    }

    @Override
    public Set<String> getMatchedKeys(String key)
    {
        Set<String> keys= new HashSet<String>();
        Iterator <org.ehcache.Cache.Entry<String,String>> it = cache.iterator();
        while (it.hasNext())
        {

            String  tk=it.next().getKey();
            if( tk.startsWith(key))  keys.add(tk );
        }

        return keys;
    }
/*
    public byte[] get(String key, byte[] defaultValue)
    {
        if (cache.containsKey(key))
        {
            String ret = cache.get(key);
            if( key.startsWith("session")  &&  ret.startsWith("validbefore"))
            {
                String t= ret.substring(11,   ret.indexOf("/"));
                Date d=   DT.string2Date(t , DATEFORMAT);
                if( d==null)  d= new Date();
                //过期了
                if( DT.isBeforeDate( d , new Date()))
                {
                    ret=null;
                    remove(key);
                }else
                {

                }

            }


            if (ret == null) return  defaultValue;
            return  Base64Coder.decode( ret.toCharArray());
        }
        return defaultValue;
    }
*/

    public void remove(String key)
    {
        cache.remove(key);
    }


    //把以  key开头的所有缓存，都删除
    public void removeMatch(String key)
    {
        Set<String> keys = new HashSet <String>();

        Iterator <org.ehcache.Cache.Entry<String,String>> it = cache.iterator();
        while (it.hasNext())
        {

            String  tk=it.next().getKey();
            if( tk.startsWith(key))  keys.add(tk);
        }

        cache.removeAll( keys );

    }

    public void removeMatchMore(Set<String> keys)
    {
        Set<String> needRemoveKeys = new HashSet<String> ();
        Iterator <org.ehcache.Cache.Entry<String,String>> it = cache.iterator();
        while (it.hasNext())
        {

            String  tk=it.next().getKey();
            for( String key : keys)
            {
                if (tk.startsWith(key)) needRemoveKeys.add(tk);
            }
        }


        cache.removeAll( needRemoveKeys );

    }

    public void removeAll(Set<String> keys)
    {
        cache.removeAll(keys);
    }

    public void close()
    {

        persistentCacheManager.close();
    }


    public int getCacheCount()
    {

        Date d1 = new Date();
        int count = 0;
        Iterator it = cache.iterator();

        while (it.hasNext())
        {
            count++;
            it.next();

        }

        Date d2 = new Date();

        DateTool dt = new DateTool();

        long cost = dt.secondsBetween(d2, d1);

        return count;


    }

    public void flush()
    {
        //

    }

}
