package cache;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public interface ICache
{

    public static String  prefix_urlOnCommision_quickCache  =  "urlOnCommision:quickCache:";

    public void put(String key, String value);
    public void put(String key, int second, String value); // 设置缓存并带上有效期

 //   public void put(String key, byte[] value);
  //  public void put(String key, int second, byte[] value); // 设置缓存并带上有效期


    public String get(String key, String defaultValue);

    //得到一组键对应的值，避免多次请求
    public JSONObject get(JSONArray keys );
    public JSONObject getMatch(String key);

    public Set<String> getMatchedKeys(String key);

 //   public byte[] get(String key, byte[] b);

    public void remove(String key);
    public void removeMatch(String key);
    public void removeMatchMore(Set<String> keys);

    public void removeAll(Set<String> keys);

    public boolean   exists(String key);
    public int  getCacheCount();

    public void flush();

}
