package appCache;

/**
 * 1 在创建岗位及部门时，不需要处理用户的部门缓存，因为 新的部门及岗位，还没有加入人员
 * 2 在部门或岗位删除，修改后，需要刷新相关的人员的部门缓存
 * 3 在应用初始化时，在cache中重建所有缓存
 * 4 在新增， 修改，删除人员后，需要刷新人员信息的缓存
 */

import app.User;
import dfs.IFileServer;
import dfs.UploadFile;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import util.AppCache;
import util.DBF;
import util.FF;
import util.Session;
import webApp.App;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import static cache.CacheBuckeyConst.USERID2ROLEIDS;

public class UserAndDepartmentCache
{

    public static final String KEY_DepartmentAndUserTreeInfo = "DepartmentAndUserTreeInfo:";

    public static String prefix_departmentInfoOfSomeone = "departmentInfoOfSomeone:";
    public static String prefix_corporationInfoOfSomeone = "corporationInfoOfSomeone:";
    public static String prefix_corporationInfo = "corporationInfo:";  //企业ID对应到企业详情
    public static String prefix_corporation2workspacemobile  = "corporationId2WorkspaceMobile:";  //企业ID对应到移动工作台入口
    public static String prefix_corporation2app  = "corporationId2App:";  //企业开通的应用




    public static String prefix_masteDepartmentIdOfSomeone = "masteDepartmentIdOfSomeone:";
    public static String prefix_detailInfoOfSomeone = "detailInfoOfSomeone:";
    public static String prefix_lastWorkingDepartmentIdOfSomeone = "lastWorkingDepartmentIdOfSomeone:";
    public static String prefix_lastCorporationOfSomeone = "lastCorporationOfSomeone:";
    public static String prefix_lastCorporationOfSession = "lastCorporationOfSession:";


    public static String prefix_userid2password = "userid2pwd:";
    public static String prefix_userid2clientcode = "userid2clientcode:";

    public static String prefix_usercode2password = "usercode2pwd:";
    public static String prefix_username2password = "username2pwd:";

    public static String prefix_useridAndPlatform2openId = "userOpenId:";



    //得用户的部门及岗位信息
    public static String getUserDepartmentInfo(int userid)
    {
        String t = AppCache.getCache(prefix_departmentInfoOfSomeone + userid, "[]");
        return t;  //是一个JSONArray串，不要转成JSONArray
    }

    //得用户的 企业信息
    public static String getUserCorproationInfo(int userid)
    {
        String t = AppCache.getCache(prefix_corporationInfoOfSomeone + userid, "[]");
        return t;  //是一个JSONArray串，不要转成JSONArray
    }

    //得到用户的主要部门
    public static String getUserMasteDepartmentId(int userid)
    {
        String t = AppCache.getCache(prefix_masteDepartmentIdOfSomeone + userid, "");
        return t;
    }

    //缓存用户的主要部门到缓存中
    public static void setUserMasteDepartmentId(int userid, String departmentid)
    {
        AppCache.setCache(prefix_masteDepartmentIdOfSomeone + userid, departmentid);

    }

    public static JSONArray  allCorporationIds()
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;

        JSONArray ret= new JSONArray();
        try
        {
            con = dbf.getConnection();
            DataStore ds = DataStoreFactory.newDataStore(con, "select id from app_corporation  where nodetype='node' and   (value is null  or value<>'false' )  ");
            int n = ds.retrieve();

            for (int i = 0; i < n; i++)
            {

                String id = ds.getString(i, "id");
                ret.put(id);
            }

        } catch (Exception e)
        {
            FF.log(e.getMessage());
        } finally
        {
            dbf.releaseConnection(con);

        }
        return ret;
    }


    //元素是String ,即 角色ID的数组
    public static JSONArray getUserRoles(int userid,String corporationid )
    {
        String t = AppCache.getCache(USERID2ROLEIDS + userid+":"+corporationid, "");
        return new JSONArray(t);
    }

    //得到用户的详细信息
    public static String getUserDetailInfo(int userid)
    {
        String t = AppCache.getCache(prefix_detailInfoOfSomeone + userid, "{}");
        return t; //是一个JSONObject串，不要转换成JSONObject

    }

    //得到上一次用户的工作部门，如果还没有选择过，且是多部门，那么选主要的部门
    //得到上一次用户的工作部门，如果还没有选择过，且是多部门，那么选主要的部门
    // 最后一次上岗时的部门（注意，是部门，要排除岗位）
    public static String getUserLastWorkingDepartmentInfo(int userid, String corpID)
    {
        String t = AppCache.getCache(prefix_lastWorkingDepartmentIdOfSomeone + userid + "@" + corpID, "");
        if (t.isEmpty())
        {

            JSONArray ja = new JSONArray(getUserDepartmentInfo(userid));
            JSONObject first = null;
            JSONObject master = null;
            for (int i = 0; i < ja.length(); i++)
            {
                JSONObject one = ja.getJSONObject(i);
                //不是同一个企业的，那么忽略
                if (!one.getString("corporationid", "").equals(corpID)) continue;
                //  （注意，是部门，要排除岗位）
                if (first == null && one.getString("station", "").equalsIgnoreCase("default")) first = one;
                if (one.getInt("ismaste", 0) == 1) master = one;
            }

            if (master == null) master = first;
            if (master != null) t = master.toString();
            setUserLastWorkingDepartmentInfo(userid, corpID, t);

        }
        return t;
    }

    public static String getSessionLastCorporationInfo(String tokenid)
    {
        String t = Session.getCache(prefix_lastCorporationOfSession + tokenid, "");
        if (t.isEmpty())
        {
            User user = User.getUserFromTokenId(tokenid);
            t = getUserLastCorporationInfo(user.getId());
        }
        return t;
    }


    private static String getUserLastCorporationInfo(int userid)
    {
        String t = AppCache.getCache(prefix_lastCorporationOfSomeone + userid, "");

        if (!t.isEmpty()) return t;

        JSONArray ja = new JSONArray(getUserCorproationInfo(userid));

        JSONObject one;
        if (ja.length() == 0)
        {
            one = new JSONObject();
        }
        else
        {
            one = ja.getJSONObject(0);
        }

        t = one.toString();
        setUserLastCorporationInfo(userid, t);

        return t;
    }

    /**
     * @param userid
     * @param corpID
     * @param departmentInfo 是当前工作部门的信息 ,包含 id , name , fullname ,station
     */
    public static boolean setUserLastWorkingDepartmentInfo(int userid, String corpID, String departmentInfo)
    {
        if (!departmentInfo.isEmpty())
        {
            //由于前端可能出现点击切换部门菜单后，没有切换，而是直接点击切换企业了，此时企业切换了，
            //但是切换部门的菜单没有关闭，如果此时再点击部门切换的菜单项，如果不加检测，就会造成不是当前企业的部门被设置成当前部门
            JSONObject js = new JSONObject(departmentInfo);
            if (!js.getString("corporationid", "").equals(corpID)) return false;
        }

        AppCache.setCache(prefix_lastWorkingDepartmentIdOfSomeone + userid + "@" + corpID, departmentInfo);
        return true;
    }

    /**
     * 设置人员最后登录的企业信息，可能是{},即没有企业
     *
     * @param userid
     * @param info
     */
    private static void setUserLastCorporationInfo(int userid, String info)
    {
        AppCache.setCache(prefix_lastCorporationOfSomeone + userid, info);

    }


    /**
     * 设置会话此时的企业信息， 同时更新会话对应人员的最后登录的企业信息。
     *
     * @param tokenid
     * @param info
     */
    public static void setSessionLastCorporationInfo(String tokenid, String info)
    {
        Session.setCache(prefix_lastCorporationOfSession + tokenid, info);

        User user = User.getUserFromTokenId(tokenid);
        setUserLastCorporationInfo(user.getId(), info);

    }


    /**
     * 重建用户详情缓存
     */
    public static void rebuildAllUserDetailInfoCache()
    {
        rebuildUserDetailInfoCache("");
        clearDepartmentAndUserTreeInfoCache();
    }

    public static void rebuildOneUserDetailInfoCache(int userid)
    {
        rebuildUserDetailInfoCache(" id=" + userid);
    }

    public static void rebuildUserDetailInfoCache(String where)
    {

        DBF dbf = DBF.getInstance();
        Connection con = null;

        FF.log("用户信息及主要部门缓存：" + where);
        try
        {
            con = dbf.getConnection();
            DataStore ds = DataStoreFactory.newDataStore(con, "select * from app_user ");
            int n = ds.retrieve(where);

            for (int i = 0; i < n; i++)
            {
               // ds.setValue(i, "password", "");
                String t = ds.getJSONRow(i, true);
                int userid = ds.getInt(i, "id");
                AppCache.setCache(prefix_detailInfoOfSomeone + userid, t);
                AppCache.setCache(prefix_masteDepartmentIdOfSomeone + userid, ds.getString(i, "departmentid"));  //主要部门ID
            }

            FF.log("用户信息及主要部门缓存：" + where + " 结束");

        } catch (Exception e)
        {
            FF.log(e.getMessage());
        } finally
        {
            dbf.releaseConnection(con);

        }

    }

    public static void rebuildUserPasswordAndClientCodeCache(String where)
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;

        FF.log("用户所属部门缓存：" + where);
        try
        {
            con = dbf.getConnection();
            DataStore ds = DataStoreFactory.newDataStore(con, "select  id, name , code , password ,clientcode from app_user ");
            int n = ds.retrieve(where);

            for (int i = 0; i < n; i++)
            {

                int userid = ds.getInt(i, "id");
                String name = ds.getString(i, "name");
                String code = ds.getString(i, "code");
                String clientcode = ds.getString(i, "clientcode");
                String passwordMD5 = FF.MD5(ds.getString(i, "password"));


                AppCache.setCache(prefix_userid2password + userid, FF.encryptString(passwordMD5));
                AppCache.setCache(prefix_usercode2password + code, FF.encryptString(passwordMD5));
                AppCache.setCache(prefix_username2password + name, FF.encryptString(passwordMD5));
                AppCache.setCache(prefix_userid2clientcode + userid, FF.encryptString(clientcode));
            }

            FF.log("用户名及密码缓存：" + where + " 结束");

        } catch (Exception e)
        {
            FF.log(e.getMessage());
        } finally
        {
            dbf.releaseConnection(con);

        }

    }

    /**
     * 重建用户所属部门的缓存
     */
    public static void rebuildAllUserDepartmentCache()
    {
        rebuildUserDepartmentCache("");
        clearDepartmentAndUserTreeInfoCache();
    }

    public static void rebuildAllUserCorporationCache()
    {

        AppCache.removeCacheMatch( prefix_corporationInfoOfSomeone); //2022.07.21 增加 ，先清除所有人的企业信息
        rebuildUserCorporationCache("");
    }


    //把指定部门及它的下级树中的人员的最后工作部门信息清除，
    //清除的原因是，可能部门名称或代码变化了，需要清理一下缓存
    public static void clearLastWorkingDepartmentInfoInSubDepartmentTree(String id)
    {


        DBF dbf = DBF.getInstance();
        Connection con = null;


        try
        {
            con = dbf.getConnection();
            String fullcode = FF.getStringFromSQL(con, "select fullcode from app_department where id='" + id + "'");
            String corpID = FF.getStringFromSQL(con, "select corporationid  from app_department where id='" + id + "'");


            String sql = "  select userid from app_department_user where departmentid in " +
                    " (  select id from app_department where (fullcode='" + fullcode + "' or fullcode like '" + fullcode + ".%' ) and nodetype='node' ) ";

            FF.log(sql);

            DataStore ds = DataStoreFactory.newDataStore(con, sql);
            int n = ds.retrieve();
            for (int i = 0; i < n; i++)
            {
                String userid = ds.getString(i, "userid");
                AppCache.removeCache(prefix_lastWorkingDepartmentIdOfSomeone + userid + "@" + corpID);
            }

            FF.log("用户所在部门信息缓存清理完成");

        } catch (Exception e)
        {
            FF.log(e.getMessage());
        } finally
        {
            dbf.releaseConnection(con);

        }

    }


    public static void rebuildOneUserDepartmentCache(int userid)
    {
        rebuildUserDepartmentCache("id=" + userid);
        clearDepartmentAndUserTreeInfoCache();
    }

    public static void rebuildOneUserCorporationCache(int userid)
    {
        rebuildUserCorporationCache("userid=" + userid);
    }


    /**
     * 缓存用户部门岗位信息，并设置它的最后一次上岗时的部门（注意，是部门，要排除岗位）
     *
     * @param where
     */
    public static void rebuildUserDepartmentCache(String where)
    {

        DBF dbf = DBF.getInstance();
        Connection con = null;

        FF.log("用户所属部门缓存：" + where);
        try
        {
            con = dbf.getConnection();


            String sql = " select  b.corporationid, b.name , b.code, b.fullname , b.id , a.station   , " +
                    "case when c.departmentid  = a.departmentid  and a.station='default' then 1 else 0 end as  ismaste  , \n" +
                    " c.id  as userid  \n" +
                    "from app_department_user  a  " +
                    "    , app_user c   \n" +
                    "    , app_department b \n" +
                    "where a.departmentid=b.id  and a.userid=c.id \n" +
                    " order by  c.id asc , b.corporationid asc ";

            HashMap<Integer, JSONArray> user2dep = new HashMap<>();//记录用户对应的部门数组
            ArrayList<String> depIdList = new ArrayList<>(); //记录所有有人员的部门ID，后面用来判断人员的最后部门是不是合法
            DataStore ds = DataStoreFactory.newDataStore(con, sql);

            if (!where.isEmpty()) where = " c.id in ( select id from app_user where " + where + ")";
            int n = ds.retrieve(where);

            HashMap<Integer, ArrayList<String>> user2crop = new HashMap<>(); //记录人员所属部门对应几个企业

            for (int i = 0; i < n; i++)
            {

                int userid = ds.getInt(i, "userid");
                String depID = ds.getString(i, "id");
                String corpID = ds.getString(i, "corporationid");

                if (!depIdList.contains(depID)) depIdList.add(depID); //所有部门的ID

                String depName = ds.getString(i, "name");
                //人员的部门信息
                JSONArray ja = user2dep.get(userid);

                if (ja == null)
                {
                    ja = new JSONArray();
                    user2dep.put(userid, ja);
                }

                ja.put(ds.getJSON(i, false));

                //人员有几个企业
                ArrayList<String> corpList = user2crop.get(userid);
                if (corpList == null)
                {
                    corpList = new ArrayList<>();
                    user2crop.put(userid, corpList);
                }

                if (!corpList.contains(corpID)) corpList.add(corpID);
            }

            //下面放到缓存中去
            Iterator<Map.Entry<Integer, JSONArray>> it = user2dep.entrySet().iterator();
            while (it.hasNext())
            {
                Map.Entry<Integer, JSONArray> one = it.next();
                JSONArray ja = one.getValue();
                int userid = one.getKey();
                //缓存用户的所有部门信息
                AppCache.setCache(prefix_departmentInfoOfSomeone + userid, one.getValue().toString());

                //对userid的每个企业，检查一下最后一次使用的部门信息
                ArrayList<String> corpList = user2crop.get(userid);
                for (int i = 0; i < corpList.size(); i++)
                {
                    String corpID = corpList.get(i);
                    String t = UserAndDepartmentCache.getUserLastWorkingDepartmentInfo(userid, corpID);
                    if (t.isEmpty()) continue; //userid可能就不属于任何部门，但凡他属于这个企业下的一个部门， 就不会是空字符串
                    JSONObject last = new JSONObject(t);
                    String lastDepID = last.getString("id", "");
                    //这个部门已经不合法 ，那么清除此用户在此企业中最后使用部门的缓存
                    // 在下次用getUserLastWorkingDepartmentInfo得到 的是空字符串时，会自动选中一个并设置，所以这里只需要清除就行了
                    if (!depIdList.contains(lastDepID)) setUserLastWorkingDepartmentInfo(userid, corpID, "");

                }
            }


            FF.log("用户所属部门缓存：" + where + " 结束");

        } catch (Exception e)
        {
            FF.log(e.getMessage());
        } finally
        {
            dbf.releaseConnection(con);

        }

    }

    /**
     * 得到企业的移动工作台代码
     * @param corporationid
     * @return
     */
    public static String  getWorkspaceMobileCodeForCorporation(String corporationid)
    {
        return  AppCache.getCache(prefix_corporation2workspacemobile  + corporationid,   "" );

    }

    public static void rebuildAllCorporationCache()
    {
        rebuildCorporationCache("");
    }

    public static void rebuildOneCorporationCache(String corporationid)
    {
        rebuildCorporationCache(" id='"+ corporationid+"' ");
    }

    public static void rebuildCorporationCache(String where)
    {

        DBF dbf = DBF.getInstance();
        Connection con = null;

        FF.log("企业信息的缓存：" + where);
        try
        {
            con = dbf.getConnection();


            //企业必须是启用状态 （  value is null or value ='true' )
            // 这里没有对用户状态做限制， 用户在登录时会限制

            String sql = "select * from v_app_corporation   ";

            DataStore ds = DataStoreFactory.newDataStore(con, sql);
            int n = ds.retrieve(where);


            for (int i = 0; i < n; i++)
            {

                String  corporationid  = ds.getString (i, "id");
                String workspaceMobile= ds.getString(i,"workspacemobile");
                String app= ds.getString(i,"app");

                String  cfg=  ds.getJSON(i,true,false,false,true).toString();

                AppCache.setCache(prefix_corporationInfo  + corporationid,   cfg);
                //企业对应的移动工作台
                AppCache.setCache(prefix_corporation2workspacemobile  + corporationid,   workspaceMobile);
                //企业开通的应用
                AppCache.setCache(prefix_corporation2app + corporationid,   app);


            }


            FF.log("用户所属企业缓存：" + where + " 结束");

        } catch (Exception e)
        {
            FF.log(e.getMessage());
        } finally
        {
            dbf.releaseConnection(con);

        }

    }


    /**
     * 重建用户对应企业的缓存
     *
     * @param where 条件中可以用  userid ,  id , name  分别指代用户ID,企业ID, 企业名称
     */
    public static void rebuildUserCorporationCache(String where)
    {

        DBF dbf = DBF.getInstance();
        Connection con = null;

        FF.log("用户所属企业的缓存：" + where);
        try
        {
            con = dbf.getConnection();


            //企业必须是启用状态 （  value is null or value ='true' )
            // 但是不要要检索时直接加上条件， 如果加上了，那么禁用的企业就取不出数据了，那么相关用户的缓存就不会被刷新，所以
            // 必须是先取出来，再判断企业启用状态，
            // 这里没有对用户状态做限制， 用户在登录时会限制

            // 2022.02.28 增加了 station属性， 记录用户是不是企业的管理员
            // 基于这样的前提： app_corporation_user 中的 station只有两种数据： user , manager  ,

            String sql = "select * from (  select  distinct  a.userid,   c.id , c.name , c.value as corporation_state, 'user' as station  " +   //人员所属部门对应的企业
                    "from app_department_user  a ,  app_department b , app_corporation c  \n" +
                    "where a.departmentid=b.id  and b.corporationid= c.id     " +
                    "          union \n" +
                    "  select  a.userid,  c.id , c.name , c.value as corporation_state, min(a.station) as station  " +
                    "  from app_corporation_user a , app_corporation c  \n" + //企业管理员
                    "    where  a.corporationid = c.id   group by a.userid,c.id,c.name ,c.value \n" +
                    "          union \n" +
                    "  select    a.id as userid,  c.id , c.name ,c.value as corporation_state, 'user' as station  " +
                    "   from app_user a , app_corporation c  \n" + // 人员默认的所属企业
                    "    where  a.corporationid = c.id     \n" +
                    " )  a  ";


            DataStore ds = DataStoreFactory.newDataStore(con, sql);
            int n = ds.retrieve(where);

            FF.log( ds.getSelectLastRetrieved());
            FF.log( ds.getError().getMessage());

            HashMap<Integer, JSONArray> user2corp = new HashMap<>();

            for (int i = 0; i < n; i++)
            {

                int userid = ds.getInt(i, "userid");
                String corpID = ds.getString(i, "id");
                String corpName = ds.getString(i, "name");
                String station  = ds.getString(i, "station");
                String corporation_state= ds.getString(i, "corporation_state");

                JSONArray ja = user2corp.get(userid);

                if (ja == null)
                {
                    ja = new JSONArray();
                    user2corp.put(userid, ja);
                }

                if( ! corporation_state.equals("false"))  ja.put(new JSONObject().put("id", corpID).put("name", corpName).put("station",station ));

            }

            //下面放到缓存中去
            Iterator<Map.Entry<Integer, JSONArray>> it = user2corp.entrySet().iterator();
            while (it.hasNext())
            {
                Map.Entry<Integer, JSONArray> one = it.next();
                JSONArray ja = one.getValue();
                int userid = one.getKey();

                AppCache.setCache(prefix_corporationInfoOfSomeone + userid, one.getValue().toString());

                //检测用户的最后登录的企业信息是不是合法的，如果不是，那么重新设置它
                String lastCorp = getUserLastCorporationInfo(userid);
                boolean lastCorpValid = false;
                for (int i = 0; i < ja.length(); i++)
                {
                    if (lastCorp.equals(ja.getJSONObject(i).toString()))
                    {
                        lastCorpValid = true;
                        break; //合法，那么不要再继续了
                    }
                }
                //  不合法，那么重新设置最后登录企业
                if (!lastCorpValid)
                {
                    FF.log("用户最后企业信息不合法，重新设置为：" + ja.getJSONObject(0).toString());
                    setUserLastCorporationInfo(userid, ja.getJSONObject(0).toString());
                }


            }


            FF.log("用户所属企业缓存：" + where + " 结束");

        } catch (Exception e)
        {
            FF.log(e.getMessage());
        } finally
        {
            dbf.releaseConnection(con);

        }

    }



    /**
     * 部门人员树信息缓存，用在IM联系人显示中，因为可能需要按人控制显示的部门，所以这个缓存是一组，而不是一个
     */
    public static void clearDepartmentAndUserTreeInfoCache()
    {
        AppCache.removeCacheMatch(KEY_DepartmentAndUserTreeInfo + ":");
    }


    //下载微信头像并上传到系统的头像库中
    public static void syncWXPortrait(String url, int userid) throws Exception
    {
        String tmpPath = App.FileRoot + "/FileServer/temp/";
        FF.MkDirs(tmpPath);

        String tmpFile = DataStoreFactory.newGUID() + ".jpg";

        FF.downloadFile(url, tmpPath, tmpFile);

        tmpFile = tmpPath + tmpFile;
        if( !FF.fileExists( tmpFile)) throw new Exception(url+"无法下载");

        //上传
        int serverIndex = 1;
        IFileServer fileServer = UploadFile.getInstance(serverIndex);
        String bucketName = fileServer.getBucketName();

        int[] sizes = new int[]{32, 48, 64, 128};
        for (int i = 0; i < sizes.length; i++)
        {
            int size = sizes[i];

            String objectName = "UserPortrait/" + size + "/" + userid + ".png";
            //上传前，删除可能之前缓存的文件
            // 如果是本地服务器，通常这个cacheFile就是真实的文件，删除它后，再重新上传，没有问题
            //如果是其它服务器，那么这个缓存的文件可能已经不存在了，但是删除一下，更保险，
            String cachedFile = fileServer.getDownloadToLocalFileName( objectName);
            FF.deleteFile(cachedFile);
            //上传文件
            if( !fileServer.objectExists( objectName))  //不要覆盖以前的头像
            {
                fileServer.upload(objectName, null, tmpFile);
            }
        }

        //更新最后上传头像时间
        FF.SafeExecute("", "update app_user  set  portraitlastupdate=" + System.currentTimeMillis() + " where id=" + userid);
        //刷新缓存
        UserAndDepartmentCache.rebuildOneUserDetailInfoCache(userid);
    }

    /**
     * 获取用户在某个平台中的openid
     * @param platformCode
     * @param userid
     * @return
     */
    public static String getUserOpenIdInPlatform(String platformCode ,String type ,  int userid)
    {
        String key= prefix_useridAndPlatform2openId+ userid+":"+platformCode;
        String v= AppCache.getCache(key,"");
        if(v.isEmpty())
        {
            v= FF.getStringFromSQL("", "select  openid from app_user_map where userid="+userid+"  and type= '"+type+"' and platform='"+ platformCode+"'");
            if(! v.isEmpty())
            {
                AppCache.setCache(key , v);
            }
        }
        return v;
    }

    public static  String  getCurrentLoginPlatform(String tokenid)
    {
        return Session.getCache(tokenid+":platform" ,"");
    }

    public static void setCurrentLoginPlatform(String tokenid ,String platform)
    {
        Session.setCache(tokenid+":platform" ,platform);
    }
}
