package app;

import config.CacheConfig;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import org.json.JSONObject;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;
import util.DBF;
import util.FF;
import util.RPCRouter;
import util.Session;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;

public class User_sixi
{
    public static User getUserFromSiXi(JSONObject param) throws Exception
    {

        final String access_token = param.getString("access_token", "", true);
        final String userInfoURL = param.getString("userInfoURL", "url3");
        final String lastloginclientcode = param.getString("lastloginclientcode", "");


        User.debugLog("sixi登录检测：access_token = " + access_token);
        User.debugLog("sixi登录检测：userInfoURL = " + userInfoURL);
        User.debugLog("sixi登录检测：client_code = " + lastloginclientcode);


        int timeoutsecond = FF.String2Int(CacheConfig.get("/登录管理/使用定制登录校验/timeoutsecond", "").trim());

        //标记1
        String t = Session.getCache(access_token, ""); //在本地用户缓存中，以access_token为key 缓存了用户信息， 格式是 时间;用户信息
        if (!t.isEmpty())
        {
            String[] s = t.split(";");
            long lastTime = FF.String2Long(s[0]);
            long current = System.currentTimeMillis();
            if ((current - lastTime) / 1000 < timeoutsecond) //  timeoutsecond 秒内使用缓存，否则重新获取
            {

                User.debugLog("直接从缓存中取sixi用户信息");
                JSONObject js = new JSONObject(FF.decryptString(s[1]));

                User user = new User(js.getInt("id", -9999),
                                     js.getString("name", "未登录"),
                                     js.getString("showname", "未登录"),
                                     js.getInt("sysuser", 0),
                                     js.getInt("isgroupmaster", 0),
                                     js.getInt("departmentid", 0),
                                     js.getInt("isarchitect", 0),
                                     js.getInt("developer", 0),
                                     js.getString("mobile", ""),
                                     js.getString("code", ""),
                                     lastloginclientcode,
                                     "0" ,
                                     js.getString("pwdmodifieddate",""),
                                     ""
                );
                return user;

            }
            else
            {
                Session.removeCache(access_token);//删除缓存

            }
        }


        String url = CacheConfig.get("/登录管理/使用定制登录校验/" + userInfoURL, "");
        User.debugLog("重新获取sixi用户信息 ，url=" + url);

        HttpURLConnection huconn = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        try
        {


            FF.trustAllHttpsCertificates();

            //创建地址对象
            URL u = new URL(url);
            //获取HttpURLConnection链接对象

            // User.debugLog(url);

            huconn = (HttpURLConnection) u.openConnection();
            //绕过证书验证，验证主机名和服务器验证方案的匹配是可接受的
            if (huconn instanceof HttpsURLConnection)
            {
                ((HttpsURLConnection) huconn).setHostnameVerifier(new CustomizedHostnameVerifier());
            }
            // 发送POST请求必须设置如下两行，如果打算使用 URL 连接进行输出，则将 DoOutput 标志设置为 true；如果不打算使用，则设置为 false。默认值为 false
            huconn.setDoOutput(true);
            //如果打算使用 URL 连接进行输入，则将 DoInput 标志设置为 true；如果不打算使用，则设置为 false。默认值为 true
            huconn.setDoInput(true);
            //设置POST方式连接
            huconn.setRequestMethod("POST");
            //创建头信息map迭代器

            //不要问为什么要加 bearer， 两个获取用户信息的接口，是不同的人写的，
            if (userInfoURL.equals("url3"))
            {
                huconn.setRequestProperty("Authorization", "bearer " + access_token);
                User.debugLog("设置 Authorization=bearer " + access_token);

            }
            else
            {
                huconn.setRequestProperty("Authorization", access_token);
                User.debugLog("设置 Authorization=" + access_token);
            }


            //连接服务器
            OutputStreamWriter out = new OutputStreamWriter(huconn.getOutputStream(), "UTF-8");
            //写入请求体
            out.write(""); //没有数据需要写入
            out.flush();
            out.close();
            // 取得输入流，并使用Reader读取,设定字符编码
            in = new BufferedReader(new InputStreamReader(huconn.getInputStream(), "UTF-8"));
            String line;
            while ((line = in.readLine()) != null)
            {
                result.append(line);
            }


            JSONObject userInfo = new JSONObject(result.toString());
            String sixiId = userInfo.getString("sixiId", "");

            //两个不同的接口，返回的信息也不同，一个直接包含 sixiId , 一个多一层data
            if (sixiId.isEmpty())
            {
                userInfo = userInfo.getJSONObject("data", null);
                if (userInfo != null) sixiId = userInfo.getString("sixiId", "");
            }

            userInfo.put("lastloginclientcode", lastloginclientcode);

            if (sixiId.isEmpty())
            {
                User.debugLog("没有sixiId ,直接返回未登录");
                return User.unLoginedUser;
            }

            String sixeId2LocalInfo = Session.getCache("sixiId:" + sixiId, "");

            if (sixeId2LocalInfo.isEmpty())
            {
                User.debugLog("本地缓存中没有找到sixiId对应的用户信息，现在缓存它");
                sixeId2LocalInfo = cacheSiXIUser(userInfo); //缓存 sixiID对应的用户信息
            }
            else
            {
                //  User.debugLog("从本地缓存中取得sixiId对应的用户信息");
            }


            //把 access_token 对应的用户信息在本地缓存一下，避免频繁调用接口，这个缓存时间不会太长，参看 本类的 标记1
            Session.setCache(access_token, System.currentTimeMillis() + ";" + sixeId2LocalInfo); //这时 sixeId2LocalInfo 包含完整的 app_user

            String s = FF.decryptString(sixeId2LocalInfo);


            JSONObject js = new JSONObject(s);

            //if ( js.getInt("freezed",0)==1) throw new Exception( js.getString("name","")+"已被冻结，禁止登录");

            if (CacheConfig.get("/登录管理/登录绑定", "false").equals("true"))
            {
                if (!Session.getCache("lastloginclientcode:" + sixiId, "").equals(lastloginclientcode))
                {
                    FF.SafeExecute("", "update app_user set  lastloginclientcode='" + lastloginclientcode + "' , " +
                            " lastlogintime='" + FF.date2String(new Date(), "yyyy.MM.dd HH:mm:ss") + "'  " +
                            " where   id=" + js.getInt("id", -9999));

                    Session.setCache("lastloginclientcode:" + sixiId, lastloginclientcode);
                }
            }

            User user = new User(js.getInt("id", -9999),
                                 js.getString("name", "未登录"),
                                 js.getString("showname", "未登录"),
                                 js.getInt("sysuser", 0),
                                 js.getInt("isgroupmaster", 0),
                                 js.getInt("departmentid", 0),
                                 js.getInt("isarchitect", 0),
                                 js.getInt("developer", 0),
                                 js.getString("mobile", ""),
                                 js.getString("code", ""),
                                 lastloginclientcode,
                                 "0",
                                 js.getString("pwdmodifieddate", ""),
                                 ""

            );

            // User.debugLog("当前登录sixi用户为："+user.getName());


            return user;


        } catch (Exception e)
        {
            User.debugLog("异常：" + e.getMessage() + "。<br><h3>请重新扫码登录。</h3>");


            throw e;

        }
        //关闭输入流
        finally
        {
            try
            {
                if (in != null)
                {
                    in.close();
                }
            } catch (IOException ex)
            {

            }

            if (huconn != null) huconn.disconnect();

        }

    }

    public static String cacheSiXIUser(JSONObject param) throws Exception
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try
        {
            con = dbf.getConnection();

            String sixiId = param.getString("sixiId", "", true);

            FF.SafeExecute(con, "delete from app_user where id<0");

            DataStore ds = DataStoreFactory.newDataStore(con, "select * from app_user  ");
            ds.retrieve(" code='" + sixiId + "'    ");

            if (ds.getRowCount() == 0)
            {
                User.debugLog("自动注册新用户" + sixiId);
                JSONObject regUserInfo = new JSONObject();

                regUserInfo.put("name", ""); //自动
                regUserInfo.put("code", param.getString("sixiId", "", true));
                regUserInfo.put("showname", param.getString("userName", "", true));
                regUserInfo.put("email", param.getString("email", "", true));
                regUserInfo.put("password", DataStoreFactory.newGUID());
                regUserInfo.put("mobile", param.getString("mobile", "", true));
                regUserInfo.put("freezed", 0);
                regUserInfo.put("backMode", true); //不做权限校验，强行注册
                //注册新用户，会自动把基本角色授与新用户，并刷新cache
                JSONObject ret = RPCRouter.dispatch("sso", "sso.Register", "register", regUserInfo, null, null, false);

                if (!ret.getBoolean("success", true))
                {
                    User.debugLog("注册用户失败：" + ret.getString("message", ""));
                }
                int userid = ret.getInt("userid", -9999);
                ds.retrieve("id=" + userid);
                User.debugLog(" new user info : " + ds.getJSONRow(0, true));

            }

            if (ds.getRowCount() == 0) throw new Exception("自动创建用户失败");

            JSONObject userInfo = ds.getJSON(0, false);

            userInfo.put("moreinfo", param.toString());
            userInfo.put("sixiId", sixiId);

            String s = userInfo.toString();
            s = FF.encryptString(s);
            Session.setCache("sixiId:" + sixiId, s);


            return s;

        } catch (Exception e)
        {
            User.debugLog(FF.exceptionMessage(e) );
            throw e;
        } finally
        {

            dbf.releaseConnection(con);

        }

    }


}



