package app;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import appCache.UserAndDepartmentCache;
import cache.CacheBuckeyConst;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.MDC;
import util.AppCache;
import util.DBF;
import util.Session;
import util.FF;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;

public class User
{

    public static String  currentLoginedUser= "currentLoginedUser";

    private int id;
    private String name;
    private String showName;
    private String mobile;
    private String code;
    private int sysuser;
    private int isgroupmaster;
    private int isarchitect;
    private int departmentId;
    private int  developer;
    public String lastloginclientcode;
    public String  portraitLastModifyDate;
    private String pwdmodifieddate="";

    private String passwordState="";

    public static User unLoginedUser = new User(-9999, "未登录", "未登录", 0, 0, 0, 0, 0,"" ,"" ,"" , "0" , "" ,"");

    public User(int id, String name, String showName, int sysuser, int isgroupmaster, int department, int isarchitect, int developer ,
                String mobile ,String code  ,String lastloginclientcode , String portraitLastModifyDate ,
                String pwdmodifieddate ,String passwordState)
    {
        this.id = id;
        this.name = name;
        this.showName = showName;
        this.sysuser = sysuser;
        this.isgroupmaster = isgroupmaster;
        this.developer=developer;
        this.departmentId = department;
        this.isarchitect = isarchitect;
        this.mobile = mobile;
        this.code= code;
        this.lastloginclientcode= lastloginclientcode;

        this.portraitLastModifyDate= portraitLastModifyDate;
        this.pwdmodifieddate =pwdmodifieddate;
        this.passwordState= passwordState;

    }

    public static void debugLog( String info)
    {
        //FF.log(info);
    }

    public static User getUserFromCookie(String cookie)
    {
        //cookie 是 document.cookies;, 示例： "userId=828; userName=hulk";
        String tokenid = FF.getTokenIdFromCookieString(cookie);
        return getUserFromTokenId(tokenid);
    }

    public static JSONArray  getUserRoles( int userid ,String corporationid )
    {
        String s= AppCache.getCache(CacheBuckeyConst.USERID2ROLEIDS + userid+":"+ corporationid,"[]");
        JSONArray roles = new JSONArray(s );
        return roles;
    }

    //通常用在页面中， 页面在检测是否登录后，把用户信息放到session中，避免重复取用户信息浪费时间
    public static User  getUserFromLocalSession(HttpServletRequest request)
    {
        Object obj=  FF.getSessionValue(request,currentLoginedUser,null);
        if( obj==null) return unLoginedUser;
        return (User)obj;
    }

    public static User getUserFromRequest(HttpServletRequest request)
    {
        String tokenid = FF.getTokenIdFromRequest(request);
        // debugLog(" ====  tokenid=" + tokenid);
        User user = getUserFromTokenId(tokenid);

        if( user.getId()>0)  //正常登录后，把登录检查循环设置成0 ， 这个变量用来防止循环登录 ，通常出现循环登录是因为第三方登录校验时，通过token获取用户信息时失败，然后
        {
            FF.setSessionValue(request, "loginCheckLoopCount", "0");
        }

        FF.setSessionValue(request,  currentLoginedUser, user);

        MDC.put("currentUserName" , user.getName());
        MDC.put("currentUserId" , ""+user.getId());

        MDC.put("isDeveloper" , user.isDeveloper()?"true":"false");


        return user;
    }


    public static User getUserFromTokenId(String tokenid)
    {

        //2019.05.20 增加，服务端脚本引擎执行RPC调用 ，模拟系统管理员
        if( tokenid.equalsIgnoreCase( FF.ScriptEngineEmulateUser))
        {   //可能用于chatWith，这样必须显示一个用户名，
            return  new User(0 , "admin", "系统", 1,0,0,1,0,"","","*" ,"0" ,
                              FF.get_yyyyMMdd_Date( new Date()) ,"");
        }

        String s = "";
        if (!tokenid.isEmpty())
        {
            s = Session.getCache(tokenid, "");
            s = FF.decryptString(s);
           //2023.08.20记录下最后活动时间

        }

        JSONObject js = new JSONObject(s);

        String userInfoType = js.getString("userInfoType", "local");

        AppCache.setCache("lastActiveDate:"+js.getInt("id",-9999), FF.get_yyyyMMddHHmmss_noDotFormatedString( new Date()));

        User user = new User(js.getInt("id", -9999),
                             js.getString("name", "未登录"),
                             js.getString("showname", "未登录"),
                             js.getInt("sysuser", 0),
                             js.getInt("isgroupmaster", 0),
                             js.getInt("departmentid", 0),
                             js.getInt("isarchitect", 0),
                             js.getInt("developer", 0),
                             js.getString("mobile", "") ,
                             js.getString("code", "") ,
                             js.getString("lastloginclientcode","") ,
                             js.getString("portraitlastupdate",""),
                             js.getString("pwdmodifieddate",""),
                             js.getString("passwordState","")

                             );

/*  2021.12.29去掉了对sixi 登录的支持
        try
        { if (userInfoType.equals("sixi")) user = User_sixi.getUserFromSiXi(js);
            //可能是异常，也可能是会话过期了，那么要把本系统的 tokenid清除，参看 loginCheck中，它仅仅
            if( user.getId()<0)
            {
                Session.removeCache(tokenid );
                String access_token = js.getString("access_token", "");
                Session.removeCache(access_token );
            }
        } catch (Exception e)
        {
            debugLog(FF.exceptionMessage( e));
            //2020.08.06增加，通常到这里，是缓存的 access_token 在sixi中过期了，需要把它从本系统的缓存中清除它
            Session.removeCache(tokenid);

            //到这里，通常是获取用户信息时 access_token  过期 ，所以返回异常，不要再循环
           return   new User(-10000, e.getMessage(), "未登录", 0, 0, 0, 0, 0,"" ,"" ,"","0");

           // return unLoginedUser;
        }
        */

        return user;

    }

    public String getPasswordState ()
    {
        return this.passwordState;
    }

    public Date  getPWDModifiedDate()
    {
        String t= this.pwdmodifieddate;
        if( t.isEmpty()) t= "2000.01.01";
        Date d=  FF.String2Date(t);
        if( d==null)  d= FF.String2Date("2000.01.01");
        return d;
    }

    public int getId()
    {
        return id;
    }

    public String getName()
    {
        return name;
    }
    public String getCode()
    {
        return code;
    }


    public String getShowName()
    {
        return showName;
    }

    public String getMobile()
    {
        return mobile;
    }

    public boolean isSysUser()
    {
        return this.sysuser == 1;
    }

    //淡化群组管理员，强化企业管理员
    public boolean isGroupMaster()
    {
        return this.isgroupmaster == 1 ||  this.isCorporationMaster();
    }

    public int getDepartmentId()
    {
        return this.departmentId;
    }

    public boolean isArchitect()
    {
        return this.isarchitect == 1;
    }

    public boolean isDeveloper()
    {
        return this.developer == 1;
    }

    //当前用户是不是指定企业的企业管理员
    public boolean isCorporationMaster( String corporationid)
    {
       JSONArray  ja= new JSONArray( UserAndDepartmentCache.getUserCorproationInfo( this.id));

       if( corporationid==null && ja.length()>0) return true;

       for( int i=0;i< ja.length();i++)
       {
           if(! ja.getJSONObject(i).getString("id","").equals( corporationid)) continue;

           if( ja.getJSONObject(i).getString("station","").equals("manager")) return true;
       }
       return false;

       // return !FF.getStringFromSQL("","select id  from app_corporation_user where userid="+
       //         this.getId()+" and corporationid='"+corporationid+"'  and station='manager' ").isEmpty();

    }

    public boolean isCorporationMaster( )
    {
        return  isCorporationMaster(null);

    }

    /**
     * 得到我管理的企业id清单
     * @return
     */
    public   ArrayList<String>  managedCorporations()
    {
        ArrayList<String> ret= new ArrayList<>();

        JSONArray  ja= new JSONArray( UserAndDepartmentCache.getUserCorproationInfo( this.id));

        for( int i=0;i< ja.length();i++)
        {
            String corpid = ja.getJSONObject(i).getString("id","")  ;
            ret.add(corpid);
        }
        return ret;
    }

    // 判断当前人员是不是指定人员所在企业的管理员
    public boolean isCorporationMasterOfSomeone( int userid )
    {
        ArrayList<String>  corps = managedCorporations();

        JSONArray  ja= new JSONArray( UserAndDepartmentCache.getUserCorproationInfo( userid));

        for( int i=0;i< ja.length();i++)
        {
            String corpid= ja.getJSONObject(i).getString("id","");
            if( corps.contains( corpid)) return true;
        }
        return false;
       // return !FF.getStringFromSQL("","select id  from app_corporation_user where userid="+
        //        this.getId() +"  and station='manager' and corporationid in ( " +
       //         "  select corporationid  from app_corporation_user where userid=  " + userid+" ) ").isEmpty();

    }

    public static JSONObject getUserInfoById(int userId)
    {
        DataStore ds= DataStoreFactory.newDataStore("", "select * from app_user where id="+ userId);
        ds.retrieve();
        if( ds.getRowCount()==0) ds.insertRow(0);
        return ds.getJSON(0,false);
    }
}
