package app;

import util.FF;
import util.NamedThreadFactory;

import java.util.concurrent.*;
import java.util.function.Function;

public class ThreadPool
{
    public static void asyncPool(String name , int poolLimit, Object[] array, Function func,   int timeout, int waitSecondsForCheckCount)
    {
        // Java线程池的完整构造函数
        /*
       ThreadPoolExecutor(
        int corePoolSize, // 正式工数量
        int maximumPoolSize, // 工人数量上限，包括正式工和临时工
        long keepAliveTime, TimeUnit unit, // 临时工游手好闲的最长时间，超过这个时间将被解雇
            BlockingQueue<Runnable> workQueue, // 排期队列
            ThreadFactory threadFactory, // 招人渠道
            RejectedExecutionHandler handler) // 拒单方式
        */
        int maxQueueSize = array.length;
        ExecutorService es = new ThreadPoolExecutor(poolLimit,
                                                    poolLimit,
                                                    0L, TimeUnit.MILLISECONDS,
                                                    new ArrayBlockingQueue<Runnable>(maxQueueSize),
                                                    new NamedThreadFactory("util.ThreadPool-"+name),
                                                    new ThreadPoolExecutor.CallerRunsPolicy());

        CountDownLatch latch = new CountDownLatch(array.length);

        for (int i = 0; i < array.length; i++)
        {
            Object data = array[i];
            final int $i = i;
            Runnable runnable = new Runnable()
            {
                @Override
                public void run()
                {
                    func.apply(data);
                    latch.countDown();
                }
            };
            //任务添加到线程池
            es.execute(runnable);

        }

        class T extends Thread
        {

            volatile boolean exit = false;

            @Override
            public void run()
            {
                long lastCount = latch.getCount();
                while (!exit)
                {
                    FF.delay(waitSecondsForCheckCount * 1000);
                    long c = latch.getCount();
                    if (c != lastCount)
                    {
                        FF.log(name+ "还有" + c + "个任务在执行中");
                        lastCount = c;
                    }
                    if (c == 0) return;
                }
            }
        } ;

        T t = new T();
        t.setName(name);
        t.start();

        try
        {
            latch.await(timeout, TimeUnit.SECONDS); // 指定超时时间
            t.exit = true;
            long c = latch.getCount();
            if (c == 0)
            {
                es.shutdown();
            }
            else
            {
                t.exit = true;
                es.shutdownNow(); // 线程池处于STOP，此时线程池不能接受新的任务，并且会去尝试终止正在执行的任务。
                FF.log(name+"-asyncPool 执行超时,剩下的" + c + "个任务被放弃");

            }
        } catch (Exception e)
        {
            t.exit = true;
            FF.log(name+"-asyncPool 执行异常" + FF.exceptionMessage(e));
            es.shutdownNow(); // 线程池处于STOP，此时线程池不能接受新的任务，并且会去尝试终止正在执行的任务。

        } finally
        {
            es.shutdown();
        }

    }
}
