
package app;

import util.FF;
import webApp.App;

import java.io.File;


public class Encoding
{

	public static String osName = System.getProperty("os.name");
	private static boolean isWindow = osName.toLowerCase().indexOf("window") >= 0;
	public static String iniFile = "";
	//文件名称的处理
	public static boolean FileNameNeedEncoding = false;
	public static String FileNameCharsetOnServer  ;
	public static String FileNameCharsetForClient  ;

	public static boolean fileContentNeedEncoding = false;
	public static String readByteWithCharset = "";

	public static boolean isWindows()
	{
		return isWindow;
	}

	//初始化

	static
	{
		init();
	}

	public static void init()
	{

		//如果是Windows操作系统，那么强制不需要进行转换
		if (isWindow)
		{
			FileNameNeedEncoding = false;
			fileContentNeedEncoding = false;
			return;
		}


			try
			{
				File f = new File(App.FileRoot  + File.separator + "charsetdetect");
				if (f.exists())
				{
					FF.log("自动检测文件名称是否需要编码转换");
					String[] fs = f.list();
					if (fs.length == 1)
					{
						String[] c = new String[]
						{ "ISO8859-1", "UTF-8", "GBK" };
						for (int m = 0; m < c.length; m++)
							for (int n = 0; n < c.length; n++)
							{
								if (new String(fs[0].getBytes(c[m]), c[n]).equals("字符集检测勿删.txt"))
								{
									FileNameCharsetOnServer = c[m];
									FileNameCharsetForClient = c[n];
									FileNameNeedEncoding = !FileNameCharsetOnServer.equals(FileNameCharsetForClient);
									break;
								}
							}

					}
				}
			} catch (Exception e)
			{

			}


		FF.log(toStr());

	}

	public static String toStr()
	{
		return "操作系统是：" + osName + "\r\n<br>" + "FileNameNeedEncoding= " + FileNameNeedEncoding + "\r\n<br>" + 
		"FileNameCharsetOnServer=" + FileNameCharsetOnServer
				+ "\r\n<br>" + "FileNameCharsetForClient=" + FileNameCharsetForClient + "\r\n<br>" 
				+ "fileContentNeedEncoding=" + fileContentNeedEncoding + "\r\n<br>"
				+ "readByteWithCharset=" + readByteWithCharset + "\r\n<br>";
	}

	/**
	 * 转换成操作系统能够访问的文件名
	 * @param fileName
	 * @return
	 */
	public static String FileName4ReadWrite(String fileName)
	{

		if (!FileNameNeedEncoding) return fileName;

		try
		{
			return new String(fileName.getBytes(FileNameCharsetForClient), FileNameCharsetOnServer);
		} catch (Exception e)
		{
			FF.log("FileName4ReadWrite 错误" + e.getMessage());
			return fileName;
		}
	}

	/**
	 * 将操作系统中文件名转换成能在页面上显示的文件名
	 * @param fileName
	 * @return
	 */
	public static String FileName4Show(String fileName)
	{
		if (!FileNameNeedEncoding) return fileName;
		try
		{
			return new String(fileName.getBytes(FileNameCharsetOnServer), FileNameCharsetForClient);
		} catch (Exception e)
		{
			FF.log("FileName4Show 错误" + e.getMessage());
			return fileName;
		}
	}

}
