/*
 * 创建日期: 2005-9-16
 *
 *
 *
 * 功能描述：
 *
 */

package app;

import com.alibaba.fastjson.JSON;
import config.CacheConfig;
import config.Config;
import jun.db.core.DataAdapter;
import jun.db.core.DataStore;
import jun.db.core.UniformDataType;
import jun.db.impl.DataStoreFactory;
import jun.db.impl.Sequence;
import jun.db.util.TimeMark;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;
import util.DBF;
import util.DBFunction;
import util.FF;
import util.RPCRouter;
import webApp.App;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;


public class DBInit implements Ilog
{

    //修正 数据
    public static String[] needAppIdTreeTables = {
            "app_bill",
            "app_document",
            "app_flow",
            "app_resource",
            "app_role",
            "app_workspace",
            "app_package_config"};

    public int feedInfoToUserID = -9999;
    public static String KEY_V = "databaseVersion";
    String appRootPath;
    String  dbpool="";

    public static DataStore dsError = null;





    public DBInit(String dbpool ,String root)
    {

        this.dbpool= dbpool;
        appRootPath = root;
    }

    public DBInit(String dbpool ,String root, int userid)
    {
        this.dbpool= dbpool;
        appRootPath = root;
        feedInfoToUserID = userid;
    }

    public void Tip(String s)
    {
        FF.log(s);
    }

    public void Init()
    {
        Init(null, false);
    }

    public void InitSystemTable()
    {
        if (feedInfoToUserID >= 0)
        {


            Init(null, true);
        }
        else
        {
            Init(null, true);
        }
    }

    public void Init(Ilog log)
    {
        Init(log, false);
    }

    public void Init(Ilog log, boolean onlyInitSystemTable)
    {

        clearError();
        mySQL_safeUpdate();

        // 做升级，应该放在建表，建视图之前， 因为刚开始，表还没有初始化，视图没有初始化，那么
        // 这里升级操作可能会失败，没关系。因为根本不需要。
        // 当系统已经不是第一次启动，那么表， 视图也建好了， 此时执行升级语句正好。
        // 在升级中删除了某些表，或视图，那么在下面的建表建视图中正好重建它们
        upgrade(   log);// 数据库升级

        InitTables(  log);

        InitIndexs(   log);

        InitViews(   log);

        InitData(log);

        InitOtherSequence( log);

        /**
         * DBInit.initSystemTable是在 App启动时，异步执行的，当它执行完成后， 触发本事件
         * 因为在initSystemTable中可能初始化数据，在做完后，需要交给app做一些处理，比如 app_config在初始化完成后 需要重建fullname
         */

        App.getInstance().afterInitSystemTable();

        FF.log("初始检测完成。");


    }


    private void clearError()
    {
        FF.SafeExecute("", "delete from app_error");

    }

    public void mySQL_safeUpdate()
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;
        try
        {
            con = dbf.getConnection();

            if (DBFunction.isMySQL(con))
            {
                FF.SafeExecute(con, " set sql_safe_updates=0 "); //允许delete命令不带where
            }

        } catch (Exception e)
        {

        } finally
        {
            dbf.releaseConnection(con);
        }
    }


    public void InitOtherSequence( Ilog log)
    {

            Sequence.InitSequence(dbpool, "wise_config.id", " select max(id) from  wise_config");

    }

    public void InitTables(   Ilog log)
    {

        FF.log(appRootPath);


        String path = appRootPath + "/config/db/table";

        File subFile = new File(path);

        String files[] = subFile.list();
        if (files == null) files = new String[0];

        for (int i = 0; i < files.length; i++)
        {
            FF.sleep(10);

            String table = files[i];
            if (!table.endsWith(".sql")) continue;
            table = table.substring(0, table.length() - 4);

            InitTable( dbpool, path, table, table + ".sql", log, null, false);
        }


    }

    public void InitUserTables(String con, Ilog log)
    {
        InitUserTables(con, log, "");
    }

    public void InitUserTables(String userCon, Ilog log, String onlyTable)
    {

        FF.log(appRootPath);

        String path = appRootPath + "/config/db/user";

        File subFile = new File(path);

        String files[] = subFile.list();
        if (files == null) files = new String[0];
        for (int i = 0; i < files.length; i++)
        {
            FF.sleep(10);

            String table = files[i];
            boolean isRef = table.endsWith(".ref"); //2016.09.11 增加， 如果在用户个人数据库中也需要建与主表完全一样的表，那么用 table名.ref 来定义，sql文件会转到 ../table/目录下去寻找
            if (!table.endsWith(".sql") && !isRef) continue;

            table = table.substring(0, table.length() - 4);

            String tableFile = table + ".sql";
            if (isRef) tableFile = "../table/" + tableFile;

            if (!onlyTable.isEmpty() && !onlyTable.equals(table)) continue;

            InitTable(userCon, path, table, tableFile, log, null, false);
        }

        // 做升级，再次做视图的检测，这样，当升级语句里删除了视图，这样视图可以重新建起来
        if (onlyTable.isEmpty()) upgrade(userCon, "user", log);// 数据库升级


    }

    public void InitViews( Ilog log)
    {

        try
        {

            String path = appRootPath + "/config/db/view";
            File subFile = new File(path);
            if (subFile == null) throw new Exception("这不是错误，因config/db/view 目录不存在，所以没有视图需要创建");

            String files[] = subFile.list();
            if (files == null) files = new String[0];

            // 排序一下
            Arrays.sort(files);

            //先删除，再重建，删除时要反序删除
            /*2018.05.03 取消了删除视图的操作，因此这个操作是在单独的线程中执行的，在执行过程中，
              可能其它的微服务正在启动中，并且需要访问到这些视图。 如果正好在删除时，其它服务用到，
              那么就出现那些服务初始化不正常。


            2018.05.06  这些系统视图有做调整，所以为了让它自动升级视图，还是先删除吧
            */


            for (int i = files.length - 1; i >= 0; i--)
            {
                FF.sleep(10);
                String table = files[i];
                if (!table.endsWith(".sql")) continue;
                table = table.substring(0, table.length() - 4);
                table = table.substring(7); // 去掉前面的序号

                if (table.startsWith("$"))
                {
                    table = table.substring(table.indexOf("_") + 1);
                }
                FF.log("先删除视图：" + table);

                if (FF.tableExists(dbpool, table))
                {
                    String err = FF.SafeExecute(dbpool, "drop view " + table);
                    if (!err.isEmpty()) initError("删除视图", err);
                }
            }

            for (int i = 0; i < files.length; i++)
            {
                FF.sleep(10);

                String table = files[i];
                if (!table.endsWith(".sql")) continue;
                table = table.substring(0, table.length() - 4);
                table = table.substring(7); // 去掉前面的序号

                if (!FF.isSQLFileForDialect(dbpool, table))
                {
                    FF.log(table + "不是当前数据方言，忽略");
                    continue;
                }

                if (table.startsWith("$"))
                {
                    table = table.substring(table.indexOf("_") + 1);
                }

                InitTable(dbpool, path, table, files[i], log, null, true);
                if (!FF.tableExists(dbpool, table))
                {
                    initError("创建视图", table + "不存在");
                }
            }
        } catch (Exception e)
        {
            FF.log(e.getMessage());
            addLog(log, null, "<br><font color=red>" + e.getMessage() + "</font>");
        }

    }

    public static void initError(String type, String info)
    {
        if (dsError == null)
        {
            dsError = DataStoreFactory.newDataStore("", "select * from app_error");
            dsError.setUpdateProperty("app_error", "id", "*", "id");
        }

        int row = dsError.insertRow(0);
        dsError.setValue(row, "id", DataStoreFactory.newGUID());
        dsError.setValue(row, "when_", new Date());
        dsError.setValue(row, "type_", type);
        dsError.setValue(row, "error_", info);
        dsError.update(true);
        dsError.reset();
    }

    public void InitIndexs( Ilog log)
    {


        String path = appRootPath + "/config/db/index";
        File subFile = new File(path);
        if (subFile == null) return;

        String files[] = subFile.list();
        if (files == null) return;

        // 排序一下
        Arrays.sort(files);


        for (int i = 0; i < files.length; i++)
        {
            FF.sleep(10);

            String table = files[i];
            if (!table.endsWith(".sql")) continue;

            InitIndex(dbpool, path, files[i], log, null);
        }


    }


    public void InitInitializes(String con, Ilog log)
    {


        String path = appRootPath + "/config/db/init";
        File subFile = new File(path);
        if (subFile == null) return;

        String files[] = subFile.list();
        if (files == null) return;

        // 排序一下
        Arrays.sort(files);


        for (int i = 0; i < files.length; i++)
        {
            FF.sleep(10);

            String table = files[i];
            if (!table.endsWith(".sql")) continue;

            InitInitialize(con, path, files[i], log, null);
        }


    }


    public static void InitTable(String con_, String tablename, Reader reader, Ilog ilog, Logger log, boolean isView)
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;
        try
        {
            con = dbf.getConnection(con_);
            InitTable(con, tablename, reader, ilog, log, isView);
        } catch (Exception e)
        {
            ilog.Tip(FF.exceptionMessage(e));
        } finally
        {
            dbf.releaseConnection(con);
        }
    }


    public static void InitTable(Connection con, String tablename, Reader reader, Ilog ilog, Logger log, boolean isView)
    {

        BufferedReader br = new BufferedReader(reader);

        DataAdapter da = DataStoreFactory.createDataAdapter(con);
        try
        {
            //		addLog(log,logFile, "***************：" + tablename);

            addLog(ilog, log, "检测表：" + tablename);

            // 如果表存在，那么就扫描字段
            boolean tableExists = FF.tableExists(con, tablename);
            boolean needInitSequence = false;
            if (tableExists)
            {

                if (isView)
                {
                    addLog(ilog, log, "        这是视图，不需要检测字段");
                    return;
                }
                //		addLog( ilog, log ,"        表" + tablename + "存在，检测字段");
                DataStore ds = DataStoreFactory.newDataStore(con, "select * from " + tablename);
                //如果有ID字段，并且它是数字，那么需要做序列号初始化
                if (ds.col2Index("id") >= 0)
                {
                    if (ds.getColumnProperty("id").getUniformDataType() == UniformDataType.$Integer || ds.getColumnProperty("id").getUniformDataType() == UniformDataType.$Numeric)
                        needInitSequence = true;
                }


                String data = null;
                StringBuffer sb = new StringBuffer(1024);
                while ((data = br.readLine()) != null)
                {
                    FF.sleep(10);
                    data = data.trim();
                    if (data.startsWith("--")) continue;
                    if (data.startsWith("//")) continue;
                    int p = data.indexOf("--");
                    if (p >= 0) data = data.substring(0, p);
                    data = data.replaceAll("\t", " ").trim(); // tab 换成空格
                    data = data.replaceAll("　", " ").trim(); // 中文空格换成英文空格
                    if (data.endsWith(",")) data = data.substring(0, data.length() - 1).trim(); // 把最后的逗号去掉
                    // ，
                    // 不能用replaceAll// 因为 numeric ( 20 , 6 ) 中也有逗号

                    if (data.toLowerCase().startsWith("create ")) continue;
                    if (data.toLowerCase().startsWith("primary ")) continue;
                    if (data.toLowerCase().startsWith("(")) data = data.substring(1).trim();
                    if (data.toLowerCase().endsWith(")")) data = data.substring(0, data.length() - 1).trim();
                    if (data.isEmpty()) continue;

                    // 基本上应该是字段了
                    int cp = data.indexOf(" ");
                    if (cp < 0) continue;
                    String colname = data.substring(0, cp).trim();
                    if (ds.col2Index(colname) < 0)
                    {
                        data = data.substring(cp).trim();
                        int p1 = data.indexOf(" ");
                        int p2 = data.indexOf("(");
                        if (p1 <= 0) p1 = 999999;
                        if (p2 <= 0) p2 = 999999;
                        int minP = Math.min(p1, p2);
                        if (minP < 0) continue; // 通常是出错了才会这样
                        String colType = data.substring(0, minP).trim();
                        colType = da.getMappedDataType(colType);

                        data = data.substring(minP);
                        //可能含有 not null , 需要把 not 去掉
                        String data2 = FF.replaceAll(data, "(\\s)*not(\\s)+null", "  null");
                        if (!data.equals(data2))
                        {
                            addLog(ilog, log, "        ***特别注意：字段" + colname + "是 " + data + " 但现在追加字段，需要改成" + data2);

                        }

                        colType = colType + data2;

                        //去掉类型与精度之间的空格， 在SQLite的驱动程序中，会把varchar (3) 返回类型为 Types。Numeric
                        //但不能去掉所有空格 ，可能还会有其它修饰关键字
                        colType = FF.replaceAll(colType, "(\\s)+[(]", "(");

                        String sql = "alter table " + tablename + "  add " + colname + " " + colType;
                        addLog(ilog, log, "        系统检测到表" + tablename + "缺少字段" + colname + "，自动补上该字段：" + sql);

                        String err = FF.SafeExecute(con, sql);
                        if (!err.isEmpty())
                        {
                            addLog(ilog, log, "<br><font color=red>" + err + "</font>");
                            initError("检测表", err);
                        }
                    }
                    else
                    {//在恢复数据时，　一个字段显示一个提示，很费时间
                        //addLog(log, "        字段:"+colname+"已存在");

                    }

                }

                //所有表都加上 thisrowlastmodifydate字段
                FF.SafeExecute(con, "alter table " + tablename + "  add thisrowlastmodifydate  " + da.getMappedDataType("datetime") + " null", false);

            }
            else
            {
                addLog(ilog, log, "<br><span >准备创建：" + tablename + "</font>");

                String data = null;
                StringBuffer sb = new StringBuffer(1024);

                while ((data = br.readLine()) != null)
                {
                    FF.sleep(10);
                    data = data.trim();
                    if (data.startsWith("--")) continue;
                    if (data.startsWith("//")) continue;
                    int p = data.indexOf("--");
                    if (p >= 0) data = data.substring(0, p).trim();
                    data = data.replaceAll("\t", " ").trim(); // tab 换成空格
                    data = data.replaceAll("　", " ").trim(); // 中文空格换成英文空格

                    //2012.01.09 可能表名与SQL语句中的表名不同， 使用给的表名
                    if (data.toLowerCase().startsWith("create") && data.toLowerCase().indexOf(" table ") > 0)
                    {
                        int tp = data.indexOf(" table ");
                        boolean endsWithK = data.trim().endsWith("(");
                        //2020.04.06增加判断 ，如果 tablename与表名称 不一样，那么可能是以表为模板创建另外的表
                        if (tp > 0) data = data.substring(0, tp) + "  table " + tablename + " ";
                        if (endsWithK) data = data + " ( \n";

                    }

                    // 不是字段，其其它语句
                    if (data.toLowerCase().startsWith("create ") || data.toLowerCase().startsWith("primary "))
                    {
                        sb.append(data).append(" ");
                        continue;
                    }

                    // 在第一个字段前可能会有一个 (
                    if (data.toLowerCase().startsWith("("))
                    {
                        data = data.substring(1).trim();
                        sb.append(" ( ");
                    }

                    if (data.isEmpty()) continue;

                    if (!isView)
                    {
                        // 基本上应该是字段了
                        int cp = data.indexOf(" ");
                        if (cp < 0) // 不是字段，那么直接把语句拼起来
                        {
                            sb.append(data);
                            continue;
                        }

                        String colname = data.substring(0, cp).trim();
                        data = data.substring(cp).trim();
                        int p1 = data.indexOf(" ");
                        int p2 = data.indexOf("(");
                        if (p1 <= 0) p1 = 999999;
                        if (p2 <= 0) p2 = 999999;
                        int minP = Math.min(p1, p2);
                        if (minP < 0) continue; // 通常是出错了才会这样
                        String colType = data.substring(0, minP).trim();
                        colType = da.getMappedDataType(colType);
                        data = data.substring(minP);

                        if (da.isOracle() || da.isPostgres())
                        {
                            // 去掉IDENTITY
                            data = FF.replaceAll(data, "IDENTITY", "");
                            data = FF.replaceAll(data, "identity", "");
                        }

                        if (da.isMySQL())
                        {
                            // 替换IDENTITY为auto_increment
                            data = FF.replaceAll(data, "IDENTITY", "auto_increment");
                            data = FF.replaceAll(data, "identity", "auto_increment");

                            //
                            if (colname.equalsIgnoreCase("id") && data.indexOf("auto_increment") >= 0 && colType.equals("numeric"))
                            {

                                colType = "int";
                            }

                        }

                        //2016.09.10增加，如果有ID字段，并且它不是自增量字段，并且不是字符型，那么才需要初始一个序列号
                        if (colname.equalsIgnoreCase("id"))
                        {
                            String t = data.toLowerCase();
                            String t2 = colType.toLowerCase();
                            if (t.indexOf("auto_increment") < 0 && t.indexOf("identity") < 0 && t2.indexOf("char") < 0)
                            {
                                needInitSequence = true;
                            }
                        }
                        //去掉类型与精度之间的空格， 在SQLite的驱动程序中，会把varchar (3) 返回类型为 Types。Numeric
                        //但不能去掉所有空格 ，可能还会有其它修饰关键字

                        colType = colType + data;
                        colType = FF.replaceAll(colType, "(\\s)+[(]", "(");
                        sb.append(colname).append(" ").append(colType).append(" \n ");
                    }
                    else
                    {
                        sb.append(data).append(" ");
                    }

                }

                addLog(ilog, log, "<br><span >创建：" + tablename + "</font>");
                addLog(ilog, log, sb.toString());

                addLog(ilog, log, sb.toString());
                String err = FF.SafeExecute(con, sb.toString());
                if (!err.isEmpty())
                {
                    addLog(ilog, log, "<br><font color=red>" + err + "</font>");
                    initError("创建表", err);
                }
            }

            // ID序列初始化
            //2014.06.17改成都要初始化ID
            if (needInitSequence)
            {
                FF.log(" initSequence('', '" + tablename + ".id' , '  select max(id) from " + tablename + "');");
                Sequence.InitSequence(con, tablename + ".id", " select max(id) from " + tablename);
                Sequence.InitNegativeSequence(con, tablename + ".id", " select min(id) from " + tablename);
            }
            else
            {
                //FF.log(tablename + "不需要用 initSequence 初始化序列号");
            }
        } catch (Exception e)
        {

            String errorInfo = e.getMessage();
            if (errorInfo == null) errorInfo = "null";
            addLog(ilog, log, "<br><font color=red>" + e.getClass().getName() + errorInfo + "</font>");
        } finally
        {
            if (br != null) try
            {
                br.close();
            } catch (Exception e)
            {
            }
        }


    }

    /**
     * tablename 与 file 中的create table 中的表名可能不同名
     */
    public static void InitTable(String dsn, String path, String tablename, String file_, Ilog ilog, Logger log, boolean isView)
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;
        try
        {
            con = dbf.getConnection(dsn);

            InitTable(con, path, tablename, file_, ilog, log, isView);

        } catch (Exception e)
        {

        } finally
        {
            dbf.releaseConnection(con);
        }
    }

    //下面是旧的，因为已经稳定运行，所以保留 ， 上面另外增加了一个函数
    public static void InitTable(Connection con, String path, String tablename, String file_, Ilog ilog, Logger log, boolean isView)
    {


        //有时候，可能file已经包含了path ,所以把path等去掉
        String file = file_;
        if (file.lastIndexOf("/") >= 0) file = file.substring(file.lastIndexOf("/") + 1);
        if (file.lastIndexOf("\\") >= 0) file = file.substring(file.lastIndexOf("\\") + 1);


        DataAdapter da = DataStoreFactory.createDataAdapter(con);
        try
        {
            //		addLog(log,logFile, "***************：" + tablename);

            addLog(ilog, log, "检测表：" + tablename);

            // 如果表存在，那么就扫描字段
            boolean tableExists = FF.tableExists(con, tablename);
            boolean needInitSequence = false;
            if (tableExists)
            {

                if (isView)
                {
                    addLog(ilog, log, "        这是视图，不需要检测字段");
                    return;
                }
                //		addLog( ilog, log ,"        表" + tablename + "存在，检测字段");
                DataStore ds = DataStoreFactory.newDataStore(con, "select * from " + tablename);
                //如果有ID字段，并且它是数字，那么需要做序列号初始化
                if (ds.col2Index("id") >= 0)
                {
                    if (ds.getColumnProperty("id").getUniformDataType() == UniformDataType.$Integer || ds.getColumnProperty("id").getUniformDataType() == UniformDataType.$Numeric)
                        needInitSequence = true;
                }

                String fileName = path + File.separator + file;
                String charsetName = DataStoreFactory.charsetDetect(fileName);
                try( BufferedReader br =   new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(fileName)), charsetName));)
                {
                    String data = null;
                    StringBuffer sb = new StringBuffer(1024);
                    while ((data = br.readLine()) != null)
                    {
                        FF.sleep(10);
                        data = data.trim();
                        if (data.startsWith("--")) continue;
                        if (data.startsWith("//")) continue;
                        int p = data.indexOf("--");
                        if (p >= 0) data = data.substring(0, p);
                        data = data.replaceAll("\t", " ").trim(); // tab 换成空格
                        data = data.replaceAll("　", " ").trim(); // 中文空格换成英文空格
                        if (data.endsWith(",")) data = data.substring(0, data.length() - 1).trim(); // 把最后的逗号去掉
                        // ，
                        // 不能用replaceAll// 因为 numeric ( 20 , 6 ) 中也有逗号

                        if (data.toLowerCase().startsWith("create ")) continue;
                        if (data.toLowerCase().startsWith("primary ")) continue;
                        if (data.toLowerCase().startsWith("(")) data = data.substring(1).trim();
                        if (data.toLowerCase().endsWith(")")) data = data.substring(0, data.length() - 1).trim();
                        if (data.isEmpty()) continue;

                        // 基本上应该是字段了
                        int cp = data.indexOf(" ");
                        if (cp < 0) continue;
                        String colname = data.substring(0, cp).trim();
                        if (ds.col2Index(colname) < 0)
                        {
                            data = data.substring(cp).trim();
                            int p1 = data.indexOf(" ");
                            int p2 = data.indexOf("(");
                            if (p1 <= 0) p1 = 999999;
                            if (p2 <= 0) p2 = 999999;
                            int minP = Math.min(p1, p2);
                            if (minP < 0) continue; // 通常是出错了才会这样
                            String colType = data.substring(0, minP).trim();
                            colType = da.getMappedDataType(colType);

                            data = data.substring(minP);
                            //可能含有 not null , 需要把 not 去掉
                            String data2 = FF.replaceAll(data, "(\\s)*not(\\s)+null", "  null");
                            if (!data.equals(data2))
                            {
                                addLog(ilog, log, "        ***特别注意：字段" + colname + "是 " + data + " 但现在追加字段，需要改成" + data2);

                            }

                            colType = colType + data2;

                            //去掉类型与精度之间的空格， 在SQLite的驱动程序中，会把varchar (3) 返回类型为 Types。Numeric
                            //但不能去掉所有空格 ，可能还会有其它修饰关键字
                            colType = FF.replaceAll(colType, "(\\s)+[(]", "(");

                            String sql = "alter table " + tablename + "  add " + colname + " " + colType;
                            addLog(ilog, log, "        系统检测到表" + tablename + "缺少字段" + colname + "，自动补上该字段：" + sql);

                            String err = FF.SafeExecute(con, sql);
                            if (!err.isEmpty())
                            {
                                addLog(ilog, log, "<br><font color=red>" + err + "</font>");
                                initError("检测表", err);
                            }
                        }
                        else
                        {//在恢复数据时，　一个字段显示一个提示，很费时间
                            //addLog(log, "        字段:"+colname+"已存在");

                        }

                    }
                }catch(Exception e)
                {

                }

                //所有表都加上 thisrowlastmodifydate字段
                FF.SafeExecute(con, "alter table " + tablename + "  add thisrowlastmodifydate  " + da.getMappedDataType("datetime") + " null", false);

            }
            else
            {
                addLog(ilog, log, "<br><span >准备创建：" + tablename + "</font>");
                StringBuffer sb = new StringBuffer(1024);

                try(BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(path + File.separator + file))));)
                {
                String data = null;

                while ((data = br.readLine()) != null)
                {
                    FF.sleep(10);
                    data = data.trim();
                    if (data.startsWith("--")) continue;
                    if (data.startsWith("//")) continue;
                    int p = data.indexOf("--");
                    if (p >= 0) data = data.substring(0, p).trim();
                    data = data.replaceAll("\t", " ").trim(); // tab 换成空格
                    data = data.replaceAll("　", " ").trim(); // 中文空格换成英文空格

                    //2012.01.09 可能表名与SQL语句中的表名不同， 使用给的表名
                    if (data.toLowerCase().startsWith("create") && data.toLowerCase().indexOf(" table ") > 0)
                    {
                        int tp = data.indexOf(" table ");
                        boolean endsWithK = data.trim().endsWith("(");
                        if (tp > 0) data = data.substring(0, tp) + "  table " + tablename + " ";
                        if (endsWithK) data = data + " ( \n";

                        //2020.04.06增加判断 ，如果 tablename与表名称 不一样，那么可能是以表为模板创建另外的表
                        if (file.toLowerCase().indexOf(tablename.toLowerCase() + ".") < 0)
                        {
                            data = "create table " + tablename + " ";
                            if (endsWithK) data = data + " ( \n";

                        }

                    }

                    // 不是字段，其其它语句
                    if (data.toLowerCase().startsWith("create ") || data.toLowerCase().startsWith("primary "))
                    {
                        sb.append(data).append(" ");
                        continue;
                    }

                    // 在第一个字段前可能会有一个 (
                    if (data.toLowerCase().startsWith("("))
                    {
                        data = data.substring(1).trim();
                        sb.append(" ( ");
                    }

                    if (data.isEmpty()) continue;

                    if (!isView)
                    {
                        // 基本上应该是字段了
                        int cp = data.indexOf(" ");
                        if (cp < 0) // 不是字段，那么直接把语句拼起来
                        {
                            sb.append(data);
                            continue;
                        }

                        String colname = data.substring(0, cp).trim();
                        data = data.substring(cp).trim();
                        int p1 = data.indexOf(" ");
                        int p2 = data.indexOf("(");
                        if (p1 <= 0) p1 = 999999;
                        if (p2 <= 0) p2 = 999999;
                        int minP = Math.min(p1, p2);
                        if (minP < 0) continue; // 通常是出错了才会这样
                        String colType = data.substring(0, minP).trim();
                        colType = da.getMappedDataType(colType);
                        data = data.substring(minP);

                        if (da.isOracle() || da.isPostgres())
                        {
                            // 去掉IDENTITY
                            data = FF.replaceAll(data, "IDENTITY", "");
                            data = FF.replaceAll(data, "identity", "");
                        }

                        if (da.isMySQL())
                        {
                            // 替换IDENTITY为auto_increment
                            data = FF.replaceAll(data, "IDENTITY", "auto_increment");
                            data = FF.replaceAll(data, "identity", "auto_increment");

                            //
                            if (colname.equalsIgnoreCase("id") && data.indexOf("auto_increment") >= 0 && colType.equals("numeric"))
                            {

                                colType = "int";
                            }

                        }

                        //2016.09.10增加，如果有ID字段，并且它不是自增量字段，并且不是字符型，那么才需要初始一个序列号
                        if (colname.equalsIgnoreCase("id"))
                        {
                            String t = data.toLowerCase();
                            String t2 = colType.toLowerCase();
                            if (t.indexOf("auto_increment") < 0 && t.indexOf("identity") < 0 && t2.indexOf("char") < 0)
                            {
                                needInitSequence = true;
                            }
                        }
                        //去掉类型与精度之间的空格， 在SQLite的驱动程序中，会把varchar (3) 返回类型为 Types。Numeric
                        //但不能去掉所有空格 ，可能还会有其它修饰关键字

                        colType = colType + data;
                        colType = FF.replaceAll(colType, "(\\s)+[(]", "(");
                        sb.append(colname).append(" ").append(colType).append(" \n ");
                    }
                    else
                    {
                        sb.append(data).append(" ");
                    }

                }

                }catch(Exception e)
                {

                }
                addLog(ilog, log, "<br><span >创建：" + tablename + "</font>");
                addLog(ilog, log, sb.toString());

                addLog(ilog, log, sb.toString());
                String err = FF.SafeExecute(con, sb.toString());
                if (!err.isEmpty())
                {
                    addLog(ilog, log, "<br><font color=red>" + err + "</font>");
                    initError("创建表", err);
                }
            }

            // ID序列初始化
            //2014.06.17改成都要初始化ID
            if (needInitSequence)
            {
                FF.log(" initSequence('', '" + tablename + ".id' , '  select max(id) from " + tablename + "');");
                Sequence.InitSequence(con, tablename + ".id", " select max(id) from " + tablename);
                Sequence.InitNegativeSequence(con, tablename + ".id", " select min(id) from " + tablename);
            }
            else
            {
                //FF.log(tablename + "不需要用 initSequence 初始化序列号");
            }
        } catch (Exception e)
        {

            String errorInfo = e.getMessage();
            if (errorInfo == null) errorInfo = "null";
            addLog(ilog, log, "<br><font color=red>" + e.getClass().getName() + errorInfo + "</font>");
        }


    }

    /**
     * tablename 与 file 中的create table 中的表名可能不同名
     */
    public static void InitIndex(String con, String path, String file, Ilog ilog, Logger log)
    {


        try
        {
            //		addLog(log,logFile, "***************：" + tablename);

            addLog(ilog, log, "检测索引：" + file);


            //数据库方言
            if (!FF.isSQLFileForDialect(con, file))
            {
                addLog(ilog, log, file + "不是当前数据库方言，忽略");
                return;
            }

            String indexName = file;
            indexName = FF.replaceAll(indexName, ".sql", "");
            if (indexName.startsWith("$"))
            {
                int p = indexName.indexOf("_");
                indexName = indexName.substring(p + 1);
            }

            addLog(ilog, log, "先删除索引:" + indexName);

            FF.dropIndex(con, indexName);


            String sql = FF.readFile(path + "/" + file);
            sql = FF.removeInvalidCharOfSQL(sql);
            addLog(ilog, log, "创建索引：" + sql);
            String err = FF.SafeExecute(con, sql, true);
            if (!err.isEmpty())
            {
                initError("创建索引", err);
            }

        } catch (Exception e)
        {

            String errorInfo = e.getMessage();
            if (errorInfo == null) errorInfo = "null";
            addLog(ilog, log, "<br><font color=red>" + e.getClass().getName() + errorInfo + "</font>");
        } finally
        {

        }
    }

    /**
     * tablename 与 file 中的create table 中的表名可能不同名
     */
    public static void InitInitialize(String con, String path, String file, Ilog ilog, Logger log)
    {

        try
        {


            //		addLog(log,logFile, "***************：" + tablename);

            addLog(ilog, log, "初始执行（请保持幂等性）：" + file);

            String sql = FF.readFile(path + "/" + file);
            FF.SafeExecute(con, sql, false);

        } catch (Exception e)
        {

            String errorInfo = e.getMessage();
            if (errorInfo == null) errorInfo = "null";
            addLog(ilog, log, "<br><font color=red>" + e.getClass().getName() + errorInfo + "</font>");
        } finally
        {

        }
    }

    public void InitData(Ilog log)
    {


        // 如果是需要初始化unit数据，那么说明是第一次进入系统，那么设置版本号
        int dbver = getDBVer("main");
        setDBVer(dbver, true); //

        //避免多个其它服务一起初始化，数据搞重复了
        if (App.appName.equals("config"))
        {
            InitCorporation(log);
            InitUser(log);
            initData(log);
            InitApp(log);
        }
    }

    private int getCurrentDBVer()
    {

        Config cfg = new Config("app_config", "");

        cfg.enter("/系统配置/" + KEY_V);

        String key = App.getInstance().getVirtualHostName();
        return cfg.get(key, -1);


    }


    /**
     * @param dbver
     * @param setWhenNull true表示，仅在没有初始设置时，才进行设置
     */
    private void setDBVer(int dbver, boolean setWhenNull)
    {

        Config cfg = new Config("app_config", "");
        cfg.enter("/系统配置/" + KEY_V);
        String key = App.getInstance().getVirtualHostName();

        if (setWhenNull)
        {
            if (cfg.get(key, "").isEmpty()) cfg.set(key, String.valueOf(dbver));
        }
        else
        {
            cfg.set(key, String.valueOf(dbver));
        }


    }


    // 初始化超级用户
    public void InitUser(Ilog log)
    {


            String con = "";


            DataStore ds = DataStoreFactory.newDataStore(con, "select * from app_user ");
            ds.retrieve("  id=0 ");
            if (ds.getRowCount() == 0) ds.insertRow(0);

            ds.setUpdateProperty("app_user", "id", "*", "id");

            ds.setValue(0, "id", 0);

            ds.setValue(0, "name", "admin");
            if (ds.getString(0, "showname").trim().isEmpty()) ds.setValue(0, "showname", "超级用户");
            if (ds.getString(0, "password").trim().isEmpty())
                ds.setValue(0, "password", FF.buildPWD("Yq23l!yc45j",0)); // 密码不要覆盖


            ds.setValue(0, "sysuser", 1);
            ds.setValue(0, "clientcode", "*"); //登录绑定设备号，默认设置成*
            ds.setValue(0, "name_firstchar", "a");
            ds.setValue(0, "showname_firstchar", "c");
            ds.setValue(0, "freezed", 0);
            ds.setValue(0, "registdate", new Date());


            ds.update(true);
            FF.log( "系统用户自检：admin . "+ds.getErrorMessage());

            FF.log(ds.getError().getMessage());


             ds.retrieve(" id=1 ");
            if ( ds.getRowCount() == 0)
            {
                ds.reset(); // 注意这个很重要，不然，下面的行号就不对了
                ds.insertRow(0);

                ds.setUpdateProperty("app_user", "id", "*", "id");

                ds.setValue(0, "id", 1);

                ds.setValue(0, "name", "sa");
                if (ds.getString(0, "showname").trim().isEmpty()) ds.setValue(0, "showname", "管理员");
                if (ds.getString(0, "password").trim().isEmpty())
                    ds.setValue(0, "password", FF.buildPWD("Abc123!@#",1)); // 密码不要覆盖

                ds.setValue(0, "sysuser", 1);
                ds.setValue(0, "developer", 1);
                ds.setValue(0, "clientcode", "*"); //登录绑定设备号，默认设置成*
                ds.setValue(0, "name_firstchar", "s");
                ds.setValue(0, "showname_firstchar", "g");
                ds.setValue(0, "freezed", 0);

                ds.setValue(0, "registdate", new Date());

                ds.update(true);
                FF.log( "系统用户自检：sa . "+ds.getErrorMessage());
            }

            // 角色的检验：

            String defaultRole = "基本角色";
            String defaultRoleId = "default";
            ds.setSelect("select  *  from app_role  where name='" + defaultRole + "'  ");
            ds.retrieve();
            ds.setUpdateProperty("app_role", "id", "*", "id");
            if (ds.getRowCount() == 0)
            {

                ds.insertRow(0);
                ds.setValue(0, "id", defaultRoleId);
                ds.setValue(0, "name", defaultRole);

                ds.setValue(0, "no", 1);
                ds.setValue(0, "pid", "0");
                ds.setValue(0, "summary", "系统缺省的角色");
                ds.setValue(0, "nodetype", "leaf");
                ds.setValue(0, "value", "normal");


                ds.update(true);
                FF.log( "系统基本角色自检： "+defaultRole+" . "+ds.getErrorMessage());
                ds.retrieve();


            }

            defaultRoleId = ds.getString(0, "id");

            ds = DataStoreFactory.newDataStore(con, " select * from  app_user_role");
            ds.setUpdateProperty("app_user_role", "id", "*", "id");

            DataStore tds =DataStoreFactory.newDataStore( "","select id from app_user where not exists ( select id from app_user_role where app_user_role.userid=app_user.id and app_user_role.roleid='" + defaultRoleId + "')");
            tds.retrieve();
            tds.setUpdateProperty("app_user_role", "id", "*", "id");
            for (int i = 0; i < tds.getRowCount(); i++)
            {
                int row = ds.insertRow(0);
                ds.setValue(row, "id", DataStoreFactory.newGUID());
                ds.setValue(row, "userid", tds.getInt(i, "id"));
                ds.setValue(row, "roleid", defaultRoleId);
            }

            ds.update(true);


            //2021.1.05 增加默认企业的属性
            String corporationid = FF.getDefaultCorporationId();
            FF.log("升级没有企业信息的人员 ");
            String sql1 = "update app_user  set  corporationid ='" + corporationid + "' where  (corporationid is null or corporationid ='') ";
            FF.log(sql1);

            FF.SafeExecute(con, sql1);
            FF.log("升级没有企业信息的部门 ");
            sql1 = "update app_department  set  corporationid ='" + corporationid + "' where  (corporationid is null or corporationid ='') ";
            FF.log(sql1);

            //收藏夹
            FF.log("升级收藏夹");
            sql1 = " update app_favorite  set  corporationid ='" + corporationid + "'  where  ( corporationid is null or corporationid ='') ";
            FF.log(sql1);
            FF.SafeExecute(con, sql1);

            FF.log("升级用户角色");
            sql1 = " update app_user_role  set  corporationid ='" + corporationid + "'  where  ( corporationid is null or corporationid ='') ";
            FF.log(sql1);
            FF.SafeExecute(con, sql1);

            //这个操作只在config服务中执行，
            // 不能在启动时把app_workerid自动清空，因为可能存在，某些服务是运行的，仅仅是把config服务重启了
            // 这种情况下，其它服务中不会重新初始化 workerid的，所以不能自动把 app_workerid清空
            // 但是在确认所有服务停止的情况下，可以手工把 app_workerid 表清空，并且手工 delete from datastore_sequence where name='app_workerid.id'
            //
            Sequence.InitSequence(con, "app_workerid.id", "select max(id) from app_workerid ");



    }


    // 初始化默认的应用程序信息
    public void InitApp(Ilog log)
    {


        //如果已经有一个企业了，那么退出
        String firstAppId = FF.getFirstAppId();
        if (firstAppId.isEmpty())
        {

            Config corp = new Config("app_app", "");
            corp.enter("默认应用", "leaf", "true");
            if (log != null) log.Tip("创建默认应用");
            firstAppId = FF.getFirstAppId();

            JSONArray corps = FF.getJSONArrayFromSQL("", "select id ,name  from app_corporation where nodetype='node' ");
            for (int i = 0; i < corps.length(); i++)
            {
                FF.addDefaultApp2Corporation(corps.getJSONObject(i).getString("id", ""));
            }

        }




 /*
 如下表不需要分appid

              app_script  如果分应用，那么改造太大了
              "app_task",
              "app_ddlb",
              "app_treedefine",
              "app_customproperty",
                app_cellproperty
                     app_config
                    app_corporation
                    app_index
                    app_db
                    app_template
                    app_mq
                    app_platform
*/


        for (int i = 0; i < needAppIdTreeTables.length; i++)
        {
            String table = needAppIdTreeTables[i];
            String sql = "update " + table + "  set appid='" + firstAppId + "' where appid is null or  appid not in (select id from app_app) ";
            FF.SafeExecute("", sql);
            if (log != null) log.Tip(sql);
        }


    }


    // 初始化默认的企业信息
    public void InitCorporation(Ilog log)
    {


        //如果已经有一个企业了，那么退出
        if (!FF.getStringFromSQL("", "select id   from app_corporation where nodetype='node' ").isEmpty()) return;

        Config corp = new Config("app_corporation", "");
        corp.enter("默认企业", "node", "true");  //true很重要，不然不被当作启用的企业
        log.Tip("创建默认企业");

        FF.SafeExecute("", "update app_corporation set value='true' where nodetype='node' and (value is null  or value='') ");


    }


    // 初始化数据

    public void initData(Ilog log)
    {


        initYAMLData("app_config", log);
        initYAMLData("app_dbpool", log);
        initYAMLData("app_role", log);

        CacheConfig.reloadConfig();

    }


    // 初始化数据
    public void initYAMLData(String table, Ilog log)
    {

        String path = appRootPath + "/config/initdata";
        String file = path + "/" + table + ".yaml";
        if (!FF.fileExists(file)) return;
        String data = FF.ReadFile(file, "UTF-8");


        Yaml yaml = new Yaml();
        //读入文件
        Map result = (Map) yaml.load(data);


        Config cfg = new Config(table, "");

        initConfigData(cfg, result);


    }

    public void initConfigData(Config cfg, Map map)
    {

        ArrayList<String> subkeys = cfg.subKeys();

        for (Object o : map.entrySet())
        {

            Map.Entry entry = (Map.Entry) o;

            String key = (String) entry.getKey();

            Object value = entry.getValue();

            if (!(value instanceof Map))
            {
                //避免覆盖，仅当key不存在时，才设置
                String nodeType = "leaf";

                //因为有些节点，被视为column数据，而不是节点数据 ，所以
                //在导初始数据时，用$加在名称前，表示不是节点数据
                if (key.startsWith("$"))
                {
                    key = key.substring(1);
                    nodeType = "column";
                }

                if (!subkeys.contains(key)) cfg.set(key, value.toString(), nodeType);
            }

            if (value instanceof Map)
            {
                cfg.enter(key);
                initConfigData(cfg, (Map) value);
                cfg.back();
            }

        }
    }


    public int getDBVer()
    {
        return getDBVer("main");
    }

    // 得到应该的版本
    public int getDBVer(String forWhat)
    {
        String s = FF.ReadFile(appRootPath + "/config/db/upgrade/" + forWhat + "/ver.txt");
        s = s.replaceAll("\\n", "");
        s = s.replaceAll("\\r", "");

        s = s.replaceAll(" ", "");

        int dbver = FF.String2Int(s);
        return dbver;
    }

    public void upgrade(    Ilog log)
    {
        upgrade( dbpool,  "main", log);
    }

    //用户个人数据的升级
    public void upgrade( String con,  String forWhat, Ilog log)
    {
        try
        {


            int curdbver = getCurrentDBVer();


            FF.log("当前系统数据库版本" + curdbver);
            int dbver = getDBVer(forWhat);


            if (curdbver == -1)//没有设置，说明还没有初始化，此时不需要升级，因为它就是一个每一次连接的新数据库
            {

                setDBVer(dbver, true);
                curdbver = dbver;
                //注意，还可能是app_config表结构没有升级，导致设置版本号失败，此时，就要升一下级
            }


            FF.log("当前软件版本" + dbver);
            for (int i = curdbver + 1; i <= dbver; i++)
            {

                String subPath = FF.right("00" + i, 3);

                File dir = new File(appRootPath + "/config/db/upgrade/" + forWhat + "/" + subPath);
                if (!dir.exists()) continue;
                String files[] = dir.list();

                if (files == null) continue;
                for (int k = 1; k <= files.length; k++)
                {
                    FF.sleep(10);

                    String sql = FF.ReadFile(appRootPath + "/config/db/upgrade/" + forWhat + "/" + subPath + "/" + k + ".sql");


                    sql = FF.removeInvalidCharOfSQL(sql);

                    if (sql.isEmpty()) continue;
                    sql = sql.trim();

                    if (sql.startsWith("ref:"))
                    {
                        String t[] = sql.split(":");
                        String table = t[1].trim();

                        if (forWhat.equals("user"))
                        {
                            FF.log("重建用户表：" + table);
                            InitUserTables(dbpool, log, table); //用户表太多了，只能这样自动处理，而主数据库中的表，通常就手工处理了，所以不再对main做处理
                        }

                    }
                    else if (sql.startsWith("rebuildTable"))
                    {

                        int p = sql.lastIndexOf(" ");
                        String table = sql.substring(p).trim();
                        //重建表
                        rebuildTable(dbpool, log, table, this.appRootPath);
                    }
                    else
                    {
                        FF.log(forWhat + "升级：" + sql);

                        FF.SafeExecute(dbpool, sql);
                    }
                }

            }

            setDBVer(dbver, false);  //强制设置数据库的版本号

        } catch (Exception e)
        {
            System.out.print("升级过程中出现错误：");
            FF.log(e.getMessage());

        }
    }

    /**
     * 当主键字段类型需要修改时，不能直接修改，只能导出数据，删除表，再建表，再导入数据
     *
     * @param con
     * @param ilog
     * @param table
     * @param appRootPath
     */
    public static void rebuildTable( String con, Ilog ilog, String table, String appRootPath)
    {
        //1 备份表的数据

        String path = App.FileRoot;//此时它已经初始化好了
        path = path + "/temp";
        FF.delTree(path);
        FF.MkDirs(path);

        //先导出数据
        exportTable(path, con, table, 2000, ilog);
        String t = FF.date2String(new Date(), "HHmmss");
        //备份一下
        FF.SafeExecute(con, "select *  into   " + table + "_" + t + "   from " + table);
        //删除表
        FF.SafeExecute(con, "drop table " + table);
        FF.SafeExecute(con, "drop table " + table + "  CASCADE"); // pgsql 必须用级联删除，同时删除相关的视图，不然，表是删除不掉的

        //重新建表
        String tablePath = appRootPath + "/config/db/table";
        InitTable(con, tablePath, table, table + ".sql", ilog, null, false);
        //再导回数据
        Import(path + "/" + table, con, table, ilog);

    }


    public static void exportTable(String path, String dsn, String table, int exportrowcountonce, Ilog ilog)
    {

        DBF dbf = DBF.getInstance();
        Connection con = null;
        try
        {
            con = dbf.getConnection(dsn);


            FF.delTree(path + "/" + table);
            FF.MkDirs(path + "/" + table);


            String tip = "正在备份表：" + table;
            if (ilog != null) ilog.Tip("<br><span>" + tip + "<span>&nbsp;<span id=progress></span>");

            DataStore ds = DataStoreFactory.newDataStore(con, "select * from " + table);
            int pc = exportrowcountonce;
            ds.setOnceRetrieveCount(pc);

            //不要关闭
            ds.setCloseResultsetAfterRetrieveOnce(false);

            ds.retrieve();
            int dbRowCount = ds.getDBRowCount();

            ds.saveAsXML(Encoding.FileName4ReadWrite(path + "/" + table + "/" + table + ".xml"));

            int PageCount = (dbRowCount - 1) / pc + 1;

            int i = 0;
            while (true && dbRowCount > 0)
            {
                ds.clearBuffer();
                if (ds.retrieveOnceMore() == 0) break;
                i++;
                String file = path + "/" + table + "/" + table + "." + i + ".xml";
                ds.saveAsXML(Encoding.FileName4ReadWrite(file));
                tip = "已完成" + (int) ((i + 1) * 100.0f / (PageCount)) + "%";
                if (ilog != null) ilog.Tip(tip);

            }


            if (ilog != null) ilog.Tip("<font color=green>[✔]</font>");


        } catch (Exception e)
        {

        } finally
        {
            dbf.releaseConnection(con);
        }

    }

    /**
     *  本函数并不对ID对特别处理，
     */
    /**
     * @param path  已经带上table名称的路径
     * @param dsn
     * @param table
     * @param ilog
     */
    public static void Import(String path, String dsn, String table, Ilog ilog)
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;
        try
        {
            con = dbf.getConnection(dsn);


            TimeMark tm = new TimeMark();


            if (!path.endsWith("\\") && !path.endsWith("/")) path = path + File.separator;

            // 是数据的一部分吗

            String dbTable = table;
            int p = table.indexOf(".");
            if (p > 0)
            {
                dbTable = table.substring(0, p);

            }

            File subFile = new File(path);
            String files[] = subFile.list();
            if (files == null) files = new String[0];

            DataStore ds = DataStoreFactory.newDataStore(con, "select * from  " + dbTable);

            ds.setUpdatable(true);

            ds.setUpdateProperty(dbTable, "id", "*", "id");

            int totalCount = 0;
            for (int i = 0; i < files.length; i++)
            {

                String s = files[i];
                if (!s.endsWith(".xml")) continue;

                ds.reset();


                ds.importXMLFile(path + s);
                tm.stamp("读入数据" + ds.getRowCount() + "笔");
                totalCount += ds.getRowCount();
                if (ilog != null)
                    ilog.Tip("<br><span> " + dbTable + "读入数据" + ds.getRowCount() + "笔，累计" + totalCount + "笔</span>");

                if (DBFunction.isOracle(con))
                {
                    if (!ds.update(true))
                        if (ilog != null) ilog.Tip("<font color=red>" + ds.getError().getMessage() + "</font>");
                }
                else
                {
                    if (!ds.importUpdate())
                        if (ilog != null) ilog.Tip("<font color=red>" + ds.getError().getMessage() + "</font>");
                }

            }
            if (ilog != null) ilog.Tip("<font color=green>[ok]</font>");


            tm.stamp("完成");


        } catch (Exception e)
        {

        } finally
        {
            dbf.releaseConnection(con);
        }

    }

    public void execOptimize(Ilog log)
    {


        DBF dbf = DBF.getInstance();
        Connection con = null;
        try
        {
            String path = appRootPath + "/config/optimize";
            File subFile = new File(path);
            if (subFile == null) return;

            String files[] = subFile.list();
            if (files == null) return;

            // 排序一下
            Arrays.sort(files);

            for (int i = 0; i < files.length; i++)
            {

                String table = files[i];
                if (!table.endsWith(".sql")) continue;
                String sql = FF.ReadFile(path + "/" + files[i]);

                con = dbf.getConnection();
                DataAdapter da = DataStoreFactory.createDataAdapter(con);
                sql = da.toLocalSyntax(sql);
                addLog(log, null, "执行：" + sql + "<br>");
                FF.SafeExecute(con, sql);

            }
        } catch (Exception e)
        {
            FF.log(e.getMessage());
            addLog(log, null, "<br><font color=red>" + e.getMessage() + "</font>");
        } finally
        {
            dbf.releaseConnection(con);
        }

    }

    public static void addLog(Ilog ilog, Logger log, String s)
    {
        FF.log(s);
        if (ilog != null) ilog.Tip("<br>" + s);
        if (log != null) log.info(s);
    }

    public static void main(String[] args)
    {
        String data = "tag2　varchar(255)  null , ";
        String data2 = data.replaceAll("　", " ").trim(); // 中文空格换成英文空格
        FF.log(data.equals(data2));
        FF.log(data2.indexOf("　"));

    }

}
