package LocalMemoryCache;


import cache.ICache;
import org.json.JSONArray;
import org.json.JSONObject;
import util.FF;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;

/**
 * @Description: 方案2，缓存实现
 * @Author laoxu
 * @Date 2019/7/27 15:24
 **/

public class InMemoryCacheWithDelayQueue implements ICache
{
    private final ConcurrentHashMap<String, SoftReference<Object>> cache = new ConcurrentHashMap<>();
    private final DelayQueue<DelayedCacheObject> cleaningUpQueue = new DelayQueue<>();

    private final static InMemoryCacheWithDelayQueue ins = new InMemoryCacheWithDelayQueue();
    private static Thread cleanerThread;

    public synchronized static InMemoryCacheWithDelayQueue getInstance()
    {
        return ins;
    }

    public static boolean  exit=false;
    public static void shutdown()
    {
        cleanerThread.interrupt();

    }

    private InMemoryCacheWithDelayQueue()
    {
        cleanerThread = new Thread(() -> {
            //在 app中终止服务时，会执行所有线程的 interrupt ,来终止线程
            while (!Thread.currentThread().isInterrupted())
            {
                try
                {
                    DelayedCacheObject delayedCacheObject = cleaningUpQueue.take();
                    cache.remove(delayedCacheObject.getKey(), delayedCacheObject.getReference());
                } catch (InterruptedException e)
                {
                    Thread.currentThread().interrupt();
                }
            }

            clear();
            FF.log("InMemoryCacheWithDelayQueue 终止");

        });
        cleanerThread.setName("内存缓存清理线程");
        cleanerThread.setDaemon(true);
        cleanerThread.start();
    }

    @Override
    public void put(String key, String value)
    {
        put(key, 60, value);
    }

    @Override
    public void put(String key, int periodInSecond, String value)
    {
        long periodInMillis = periodInSecond * 1000;
        if (key == null)
        {
            return;
        }
        if (value == null)
        {
            cache.remove(key);
        }
        else
        {
            long expiryTime = System.currentTimeMillis() + periodInMillis;
            SoftReference<Object> reference = new SoftReference<>(value);
            cache.put(key, reference);
            cleaningUpQueue.put(new DelayedCacheObject(key, reference, expiryTime));
        }
    }

    @Override
    public void remove(String key)
    {
        cache.remove(key);
    }

    @Override
    public String get(String key, String defaultValue)
    {
        Object ret = Optional.ofNullable(cache.get(key)).map(SoftReference::get).orElse(null);
        if (ret == null) return defaultValue;
        return (String) ret;
    }


    public void clear()
    {
        cache.clear();
    }


    public long size()
    {
        return cache.size();
    }

    @Override
    public JSONObject get(JSONArray keys)
    {
        return null;
    }

    @Override
    public JSONObject getMatch(String key)
    {
        return null;
    }

    @Override
    public Set<String> getMatchedKeys(String key)
    {
        return null;
    }

    @Override
    public void removeMatch(String key)
    {

    }

    @Override
    public void removeMatchMore(Set<String> keys)
    {

    }


    @Override
    public void removeAll(Set<String> keys)
    {

    }

    @Override
    public boolean exists(String key)
    {
        return false;
    }

    @Override
    public int getCacheCount()
    {
        return 0;
    }

    @Override
    public void flush()
    {

    }

}

