/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.models;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class DictionaryTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -8835275996639701776L;
    protected PdfDictionary dictionary;
    protected ArrayList<PdfName> keys = new ArrayList();
    private String tempKey;
    private String tempValue;

    public DictionaryTableModel(PdfDictionary dictionary) {
        this.dictionary = dictionary;
        for (PdfName n : dictionary.getKeys()) {
            this.keys.add(n);
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.dictionary.size() + 1;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex < 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int lastRow = this.keys.size();
        if (rowIndex == lastRow) {
            if (columnIndex == 0) {
                return this.tempKey;
            }
            if (columnIndex == 1) {
                return this.tempValue;
            }
        }
        switch (columnIndex) {
            case 0: {
                return this.keys.get(rowIndex);
            }
            case 1: {
                return this.dictionary.get(this.keys.get(rowIndex));
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int rowCount = this.getRowCount();
        if (rowIndex == rowCount - 1) {
            if (columnIndex == 0) {
                this.tempKey = (String)aValue;
            } else if (columnIndex == 1) {
                this.tempValue = (String)aValue;
            }
        } else if (columnIndex == 0) {
            String key = (String)aValue;
            if (key.contains("/")) {
                key = key.replace("/", "");
            }
            PdfName oldName = this.keys.get(rowIndex);
            PdfName newName = new PdfName(key);
            this.keys.set(rowIndex, newName);
            PdfObject pdfObject = this.dictionary.get(oldName);
            this.dictionary.remove(oldName);
            this.dictionary.put(newName, pdfObject);
        } else {
            String value = (String)aValue;
            PdfObject pdfObject = this.dictionary.get(this.keys.get(rowIndex));
            if (pdfObject instanceof PdfArray) {
                value = value.replaceAll(",", "");
            }
            this.dictionary.put(this.keys.get(rowIndex), (PdfObject)new PdfLiteral(value));
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Key";
            }
            case 1: {
                return "Value";
            }
            case 2: {
                return "";
            }
        }
        return null;
    }

    public void removeRow(int rowNumber) {
        PdfName name = this.keys.get(rowNumber);
        this.keys.remove(rowNumber);
        this.dictionary.remove(name);
        this.fireTableDataChanged();
    }

    public void addRow(String keyField, String valueField, int type) {
        PdfName newEntry;
        if (keyField.startsWith("/")) {
            keyField = keyField.replace("/", "");
        }
        if (!this.dictionary.contains(newEntry = new PdfName(keyField))) {
            this.dictionary.put(newEntry, (PdfObject)new PdfLiteral(type, valueField));
            this.keys.add(newEntry);
        }
        this.fireTableDataChanged();
        this.tempKey = "";
        this.tempValue = "";
    }
}

