/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.controller;

import com.itextpdf.rups.controller.PdfReaderController;
import com.itextpdf.rups.io.FileChooserAction;
import com.itextpdf.rups.io.FileCloseAction;
import com.itextpdf.rups.model.PdfFile;
import com.itextpdf.rups.view.Console;
import com.itextpdf.rups.view.PageSelectionListener;
import com.itextpdf.rups.view.RupsMenuBar;
import com.itextpdf.rups.view.contextmenu.ConsoleContextMenu;
import com.itextpdf.rups.view.contextmenu.ContextMenuMouseListener;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfStamper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.Observable;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class RupsController
extends Observable
implements TreeSelectionListener,
PageSelectionListener {
    protected PdfFile pdfFile;
    protected StringBuilder rawText = new StringBuilder();
    protected PdfReaderController readerController;
    protected RupsMenuBar menuBar = new RupsMenuBar(this);
    protected JSplitPane masterComponent;

    public RupsController(Dimension dimension) {
        this.addObserver(this.menuBar);
        Console console = Console.getInstance();
        this.addObserver(console);
        this.readerController = new PdfReaderController(this, this);
        this.addObserver(this.readerController);
        this.masterComponent = new JSplitPane();
        this.masterComponent.setOrientation(0);
        this.masterComponent.setDividerLocation((int)(dimension.getHeight() * 0.7));
        this.masterComponent.setDividerSize(2);
        this.masterComponent.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(1);
                Transferable t = dtde.getTransferable();
                LinkedList<File> files = null;
                try {
                    if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        files = (LinkedList<File>)t.getTransferData(DataFlavor.javaFileListFlavor);
                    }
                    if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String urls = (String)t.getTransferData(DataFlavor.stringFlavor);
                        files = new LinkedList<File>();
                        StringTokenizer tokens = new StringTokenizer(urls);
                        while (tokens.hasMoreTokens()) {
                            String urlString = tokens.nextToken();
                            URL url = new URL(urlString);
                            files.add(new File(URLDecoder.decode(url.getFile(), "UTF-8")));
                        }
                    }
                    if (files == null || files.size() != 1) {
                        JOptionPane.showMessageDialog(RupsController.this.masterComponent, "You can only open one file!", "Error", 0);
                    } else {
                        RupsController.this.loadFile((File)files.get(0));
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(RupsController.this.masterComponent, "Error opening file: " + e.getMessage(), "Error", 0);
                }
                dtde.dropComplete(true);
            }
        });
        JSplitPane content = new JSplitPane();
        this.masterComponent.add((Component)content, "top");
        JSplitPane info = new JSplitPane();
        this.masterComponent.add((Component)info, "bottom");
        content.setOrientation(1);
        content.setDividerLocation((int)(dimension.getWidth() * 0.6));
        content.setDividerSize(1);
        content.add((Component)new JScrollPane(this.readerController.getPdfTree()), "left");
        content.add((Component)this.readerController.getNavigationTabs(), "right");
        info.setDividerLocation((int)(dimension.getWidth() * 0.3));
        info.setDividerSize(1);
        info.add((Component)this.readerController.getObjectPanel(), "left");
        JTabbedPane editorPane = this.readerController.getEditorTabs();
        JScrollPane cons = new JScrollPane(console.getTextArea());
        console.getTextArea().addMouseListener(new ContextMenuMouseListener(ConsoleContextMenu.getPopupMenu(console.getTextArea()), cons));
        editorPane.addTab("Console", null, cons, "Console window (System.out/System.err)");
        editorPane.setSelectedComponent(cons);
        info.add((Component)editorPane, "right");
    }

    public RupsController(Dimension dimension, File f) {
        this(dimension);
        this.loadFile(f);
    }

    public RupsMenuBar getMenuBar() {
        return this.menuBar;
    }

    public Component getMasterComponent() {
        return this.masterComponent;
    }

    @Override
    public void notifyObservers(Object obj) {
        if (obj instanceof FileChooserAction) {
            File file = ((FileChooserAction)obj).getFile();
            if (((FileChooserAction)obj).isNewFile()) {
                this.saveFile(file);
            } else {
                this.loadFile(file);
            }
            return;
        }
        if (obj instanceof FileCloseAction) {
            this.pdfFile = null;
            this.setChanged();
            super.notifyObservers("Close");
            return;
        }
    }

    public void loadFile(File file) {
        try {
            byte[] contents = this.readFileToByteArray(file);
            this.pdfFile = new PdfFile(contents);
            this.pdfFile.setDirectory(file.getParentFile());
            this.pdfFile.setFilename(file.getName());
            this.setChanged();
            super.notifyObservers("Open");
            this.readerController.startObjectLoader(this.pdfFile);
            this.readerController.addNonObserverTabs(this.pdfFile);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.masterComponent, ioe.getMessage(), "Dialog", 0);
        }
        catch (DocumentException de) {
            JOptionPane.showMessageDialog(this.masterComponent, de.getMessage(), "Dialog", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFileToByteArray(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        InputStream inputStream = null;
        try {
            byte[] buffer = new byte[4096];
            byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = new FileInputStream(file);
            int read = 0;
            while ((read = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, read);
            }
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void saveFile(File file) {
        try {
            int choice;
            if (file.exists() && ((choice = JOptionPane.showConfirmDialog(this.masterComponent, "File already exists, would you like to overwrite file?", "Warning", 1)) == 1 || choice == 2)) {
                return;
            }
            if (!file.getName().endsWith(".pdf")) {
                file = new File(file.getPath() + ".pdf");
            }
            this.pdfFile.getPdfReader().removeUnusedObjects();
            PdfStamper stamper = new PdfStamper(this.pdfFile.getPdfReader(), (OutputStream)new FileOutputStream(file));
            stamper.close();
            JOptionPane.showMessageDialog(this.masterComponent, "File saved.", "Dialog", 1);
            this.loadFile(file);
        }
        catch (DocumentException de) {
            JOptionPane.showMessageDialog(this.masterComponent, de.getMessage(), "Dialog", 0);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.masterComponent, ioe.getMessage(), "Dialog", 0);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        Object selectednode = this.readerController.getPdfTree().getLastSelectedPathComponent();
        if (selectednode instanceof PdfTrailerTreeNode) {
            this.menuBar.update(this, "File");
            return;
        }
        if (selectednode instanceof PdfObjectTreeNode) {
            this.readerController.update(this, selectednode);
        }
    }

    @Override
    public int gotoPage(int pageNumber) {
        this.readerController.gotoPage(pageNumber);
        return pageNumber;
    }

    public PdfFile getPdfFile() {
        return this.pdfFile;
    }
}

