/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.rups.controller.PdfReaderController;
import com.itextpdf.rups.model.ObjectLoader;
import com.itextpdf.rups.model.TreeNodeFactory;
import com.itextpdf.rups.view.icons.IconTreeCellRenderer;
import com.itextpdf.rups.view.itext.treenodes.OutlineTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.itextpdf.text.pdf.PdfName;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;

public class OutlineTree
extends JTree
implements TreeSelectionListener,
Observer {
    protected PdfReaderController controller;
    private static final long serialVersionUID = 5646572654823301007L;

    public OutlineTree(PdfReaderController controller) {
        this.controller = controller;
        this.setCellRenderer(new IconTreeCellRenderer());
        this.setModel(new DefaultTreeModel(new OutlineTreeNode()));
        this.addTreeSelectionListener(this);
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (obj == null) {
            this.setModel(new DefaultTreeModel(new OutlineTreeNode()));
            this.repaint();
            return;
        }
        if (obj instanceof ObjectLoader) {
            PdfTrailerTreeNode trailer;
            PdfObjectTreeNode catalog;
            ObjectLoader loader = (ObjectLoader)obj;
            TreeNodeFactory factory = loader.getNodes();
            PdfObjectTreeNode outline = factory.getChildNode(catalog = factory.getChildNode(trailer = this.controller.getPdfTree().getRoot(), PdfName.ROOT), PdfName.OUTLINES);
            if (outline == null) {
                return;
            }
            OutlineTreeNode root = new OutlineTreeNode();
            PdfObjectTreeNode first = factory.getChildNode(outline, PdfName.FIRST);
            if (first != null) {
                this.loadOutline(factory, root, first);
            }
            this.setModel(new DefaultTreeModel(root));
        }
    }

    private void loadOutline(TreeNodeFactory factory, OutlineTreeNode parent, PdfObjectTreeNode child) {
        PdfObjectTreeNode next;
        OutlineTreeNode childnode = new OutlineTreeNode(child);
        parent.add(childnode);
        PdfObjectTreeNode first = factory.getChildNode(child, PdfName.FIRST);
        if (first != null) {
            this.loadOutline(factory, childnode, first);
        }
        if ((next = factory.getChildNode(child, PdfName.NEXT)) != null) {
            this.loadOutline(factory, parent, next);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        if (this.controller == null) {
            return;
        }
        OutlineTreeNode selectednode = (OutlineTreeNode)this.getLastSelectedPathComponent();
        PdfObjectTreeNode node = selectednode.getCorrespondingPdfObjectNode();
        if (node != null) {
            this.controller.selectNode(node);
        }
    }
}

