/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.contextmenu;

import com.itextpdf.rups.view.contextmenu.AbstractRupsAction;
import com.itextpdf.rups.view.itext.PdfTree;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class SaveToFilePdfTreeAction
extends AbstractRupsAction {
    private static final long serialVersionUID = -4071226227368629514L;
    private boolean saveRawBytes;

    public SaveToFilePdfTreeAction(String name) {
        super(name);
    }

    public SaveToFilePdfTreeAction(String name, Component invoker) {
        super(name, invoker);
    }

    public SaveToFilePdfTreeAction(String name, Component invoker, boolean raw) {
        super(name, invoker);
        this.saveRawBytes = raw;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        if (this.saveRawBytes) {
            fileChooser.setDialogTitle(fileChooser.getDialogTitle() + " raw bytes");
        }
        int choice = fileChooser.showSaveDialog(null);
        String path = null;
        if (choice == 0) {
            path = fileChooser.getSelectedFile().getPath();
            PdfTree tree = (PdfTree)this.invoker;
            TreeSelectionModel selectionModel = tree.getSelectionModel();
            TreePath[] paths = selectionModel.getSelectionPaths();
            PdfObjectTreeNode lastPath = (PdfObjectTreeNode)paths[0].getLastPathComponent();
            PdfObject object = lastPath.getPdfObject();
            PRStream stream = (PRStream)object;
            try {
                byte[] array = null;
                array = this.saveRawBytes ? PdfReader.getStreamBytesRaw(stream) : PdfReader.getStreamBytes(stream);
                FileOutputStream fos = new FileOutputStream(path);
                fos.write(array);
                fos.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

