/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view;

import com.itextpdf.rups.controller.RupsController;
import com.itextpdf.rups.io.FileChooserAction;
import com.itextpdf.rups.io.FileCloseAction;
import com.itextpdf.rups.io.filters.PdfFilter;
import com.itextpdf.rups.model.PdfFile;
import com.itextpdf.rups.view.MessageAction;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class RupsMenuBar
extends JMenuBar
implements Observer {
    public static final String FILE_MENU = "File";
    public static final String OPEN = "Open";
    public static final String OPENINVIEWER = "Open in PDF Viewer";
    public static final String CLOSE = "Close";
    public static final String SAVE_AS = "Save as...";
    public static final String HELP_MENU = "Help";
    public static final String ABOUT = "About";
    public static final String VERSION = "Version";
    protected Observable observable;
    protected FileChooserAction fileChooserAction;
    protected FileChooserAction fileSaverAction;
    protected HashMap<String, JMenuItem> items;
    private static final long serialVersionUID = 6403040037592308742L;

    public RupsMenuBar(final Observable observable) {
        this.observable = observable;
        this.items = new HashMap();
        this.fileChooserAction = new FileChooserAction(observable, OPEN, PdfFilter.INSTANCE, false);
        this.fileSaverAction = new FileChooserAction(observable, "Save As...", PdfFilter.INSTANCE, true);
        MessageAction message = new MessageAction();
        JMenu file = new JMenu(FILE_MENU);
        this.addItem(file, OPEN, this.fileChooserAction, KeyStroke.getKeyStroke(79, 128));
        this.addItem(file, CLOSE, new FileCloseAction(observable), KeyStroke.getKeyStroke(87, 128));
        this.addItem(file, SAVE_AS, this.fileSaverAction, KeyStroke.getKeyStroke(83, 128));
        file.addSeparator();
        this.addItem(file, OPENINVIEWER, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        PdfFile pdfFile = ((RupsController)observable).getPdfFile();
                        if (pdfFile != null && pdfFile.getDirectory() != null) {
                            File myFile = new File(pdfFile.getDirectory(), pdfFile.getFilename());
                            Desktop.getDesktop().open(myFile);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }, KeyStroke.getKeyStroke(79, 512));
        this.add(file);
        this.add(Box.createGlue());
        JMenu help = new JMenu(HELP_MENU);
        this.addItem(help, ABOUT, message);
        this.addItem(help, VERSION, message);
        this.add(help);
        this.enableItems(false);
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (OPEN.equals(obj)) {
            this.enableItems(true);
            return;
        }
        if (CLOSE.equals(obj)) {
            this.enableItems(false);
            return;
        }
        if (FILE_MENU.equals(obj)) {
            this.fileChooserAction.actionPerformed(null);
        }
    }

    protected void addItem(JMenu menu, String caption, ActionListener action) {
        this.addItem(menu, caption, action, null);
    }

    protected void addItem(JMenu menu, String caption, ActionListener action, KeyStroke keyStroke) {
        JMenuItem item = new JMenuItem(caption);
        item.addActionListener(action);
        if (keyStroke != null) {
            item.setAccelerator(keyStroke);
        }
        menu.add(item);
        this.items.put(caption, item);
    }

    protected void enableItems(boolean enabled) {
        this.enableItem(CLOSE, enabled);
        this.enableItem(SAVE_AS, enabled);
        this.enableItem(OPENINVIEWER, enabled);
    }

    protected void enableItem(String caption, boolean enabled) {
        this.items.get(caption).setEnabled(enabled);
    }
}

