/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.model;

import com.itextpdf.rups.model.Permissions;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.exceptions.BadPasswordException;
import com.itextpdf.text.pdf.PdfReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

public class PdfFile {
    protected File directory = null;
    protected String filename = null;
    protected PdfReader reader = null;
    protected Permissions permissions = null;
    protected String rawContent = null;

    public PdfFile(File file) throws IOException, DocumentException {
        if (file == null) {
            throw new IOException("No file selected.");
        }
        PdfReader.debugmode = true;
        this.directory = file.getParentFile();
        this.filename = file.getName();
        try {
            this.readFile(new FileInputStream(file), false);
        }
        catch (BadPasswordException bpe) {
            this.readFile(new FileInputStream(file), true);
        }
    }

    public PdfFile(byte[] file) throws IOException, DocumentException {
        PdfReader.debugmode = true;
        this.rawContent = new String(file, "Cp1252");
        try {
            this.readFile(new ByteArrayInputStream(file), false);
        }
        catch (BadPasswordException bpe) {
            this.readFile(new ByteArrayInputStream(file), true);
        }
    }

    protected void readFile(InputStream fis, boolean checkPass) throws IOException, DocumentException {
        this.permissions = new Permissions();
        if (checkPass) {
            final JPasswordField passwordField = new JPasswordField(32);
            JOptionPane pane = new JOptionPane(passwordField, 3, 2){
                private static final long serialVersionUID = 3695604506510737289L;

                @Override
                public void selectInitialValue() {
                    passwordField.requestFocusInWindow();
                }
            };
            pane.createDialog(null, "Enter the User or Owner Password of this PDF file").setVisible(true);
            byte[] password = new String(passwordField.getPassword()).getBytes();
            this.reader = new PdfReader(fis, password);
            this.permissions.setEncrypted(true);
            this.permissions.setCryptoMode(this.reader.getCryptoMode());
            this.permissions.setPermissions((int)this.reader.getPermissions());
            if (this.reader.isOpenedWithFullPermissions()) {
                this.permissions.setOwnerPassword(password);
                this.permissions.setUserPassword(this.reader.computeUserPassword());
            } else {
                JOptionPane.showMessageDialog(null, "You opened the document using the user password instead of the owner password.");
            }
        } else {
            this.reader = new PdfReader(fis);
            this.permissions.setEncrypted(false);
        }
    }

    public PdfReader getPdfReader() {
        return this.reader;
    }

    public String getFilename() {
        return this.filename;
    }

    public File getDirectory() {
        return this.directory;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

