/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.model;

import com.itextpdf.rups.model.BackgroundTask;
import com.itextpdf.rups.model.IndirectObjectFactory;
import com.itextpdf.rups.model.ProgressDialog;
import com.itextpdf.rups.model.TreeNodeFactory;
import com.itextpdf.text.pdf.PdfReader;
import java.util.Observable;

public class ObjectLoader
extends BackgroundTask {
    protected Observable observable;
    protected PdfReader reader;
    protected IndirectObjectFactory objects;
    protected TreeNodeFactory nodes;
    private String loaderName;

    public ObjectLoader(Observable observable, PdfReader reader, String loaderName) {
        this.observable = observable;
        this.reader = reader;
        this.loaderName = loaderName;
        this.start();
    }

    public PdfReader getReader() {
        return this.reader;
    }

    public IndirectObjectFactory getObjects() {
        return this.objects;
    }

    public TreeNodeFactory getNodes() {
        return this.nodes;
    }

    public String getLoaderName() {
        return this.loaderName;
    }

    @Override
    public void doTask() {
        ProgressDialog progress = new ProgressDialog(null, "Reading PDF file");
        this.objects = new IndirectObjectFactory(this.reader);
        int n = this.objects.getXRefMaximum();
        progress.setMessage("Reading the Cross-Reference table");
        progress.setTotal(n);
        while (this.objects.storeNextObject()) {
            progress.setValue(this.objects.getCurrent());
        }
        progress.setTotal(0);
        this.nodes = new TreeNodeFactory(this.objects);
        progress.setMessage("Updating GUI");
        this.observable.notifyObservers(this);
        progress.dispose();
    }
}

