/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.model;

import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import java.util.ArrayList;

public class IndirectObjectFactory {
    protected PdfReader reader;
    protected int current;
    protected int n;
    protected ArrayList<PdfObject> objects = new ArrayList();
    protected IntHashtable idxToRef = new IntHashtable();
    protected IntHashtable refToIdx = new IntHashtable();

    public IndirectObjectFactory(PdfReader reader) {
        this.reader = reader;
        this.current = -1;
        this.n = reader.getXrefSize();
    }

    public int getCurrent() {
        return this.current;
    }

    public int getXRefMaximum() {
        return this.n;
    }

    public boolean storeNextObject() {
        while (this.current < this.n) {
            ++this.current;
            PdfObject object = this.reader.getPdfObjectRelease(this.current);
            if (object == null) continue;
            int idx = this.size();
            this.idxToRef.put(idx, this.current);
            this.refToIdx.put(this.current, idx);
            this.store(object);
            return true;
        }
        return false;
    }

    private void store(PdfObject object) {
        PdfDictionary dict;
        if (object.isDictionary() && PdfName.PAGE.equals((dict = (PdfDictionary)object).get(PdfName.TYPE))) {
            this.objects.add(dict);
            return;
        }
        this.objects.add(PdfNull.PDFNULL);
    }

    public int size() {
        return this.objects.size();
    }

    public int getIndexByRef(int ref) {
        return this.refToIdx.get(ref);
    }

    public int getRefByIndex(int i) {
        return this.idxToRef.get(i);
    }

    public PdfObject getObjectByIndex(int i) {
        return this.getObjectByReference(this.getRefByIndex(i));
    }

    public PdfObject getObjectByReference(int ref) {
        return this.objects.get(this.getIndexByRef(ref));
    }

    public PdfObject loadObjectByReference(int ref) {
        PdfObject object = this.getObjectByReference(ref);
        if (object instanceof PdfNull) {
            int idx = this.getIndexByRef(ref);
            object = this.reader.getPdfObject(ref);
            this.objects.set(idx, object);
        }
        return object;
    }
}

