/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.io;

import com.itextpdf.rups.controller.RupsController;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Observable;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileChooserAction
extends AbstractAction {
    protected Observable observable;
    protected FileFilter filter;
    protected boolean newFile;
    protected File file;
    private File lastSelectedFolder;
    private static final long serialVersionUID = 2225830878098387118L;

    public FileChooserAction(Observable observable, String caption, FileFilter filter, boolean newFile) {
        super(caption);
        this.observable = observable;
        this.filter = filter;
        this.newFile = newFile;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int okCancel;
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(this.lastSelectedFolder);
        fc.setSelectedFile(this.file);
        if (this.filter != null) {
            fc.setFileFilter(this.filter);
        }
        if ((okCancel = this.newFile ? fc.showSaveDialog(((RupsController)this.observable).getMasterComponent()) : fc.showOpenDialog(((RupsController)this.observable).getMasterComponent())) == 0) {
            this.file = fc.getSelectedFile();
            this.lastSelectedFolder = fc.getCurrentDirectory();
            this.observable.notifyObservers(this);
        }
    }

    public boolean isNewFile() {
        return this.newFile;
    }
}

