/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.controller;

import com.itextpdf.rups.io.listeners.PdfTreeNavigationListener;
import com.itextpdf.rups.model.ObjectLoader;
import com.itextpdf.rups.model.PdfFile;
import com.itextpdf.rups.model.TreeNodeFactory;
import com.itextpdf.rups.view.PageSelectionListener;
import com.itextpdf.rups.view.contextmenu.PdfTreeContextMenu;
import com.itextpdf.rups.view.contextmenu.PdfTreeContextMenuMouseListener;
import com.itextpdf.rups.view.itext.FormTree;
import com.itextpdf.rups.view.itext.OutlineTree;
import com.itextpdf.rups.view.itext.PagesTable;
import com.itextpdf.rups.view.itext.PdfObjectPanel;
import com.itextpdf.rups.view.itext.PdfTree;
import com.itextpdf.rups.view.itext.StructureTree;
import com.itextpdf.rups.view.itext.SyntaxHighlightedStreamPane;
import com.itextpdf.rups.view.itext.XRefTable;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfObject;
import java.awt.event.KeyListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.TreeSelectionListener;

public class PdfReaderController
extends Observable
implements Observer {
    protected PdfTree pdfTree = new PdfTree();
    protected JTabbedPane navigationTabs;
    protected PagesTable pages;
    protected OutlineTree outlines;
    protected StructureTree structure;
    protected FormTree form;
    protected XRefTable xref;
    protected PdfObjectPanel objectPanel;
    protected JTabbedPane editorTabs;
    protected SyntaxHighlightedStreamPane streamPane;
    protected TreeNodeFactory nodes;

    public PdfReaderController(TreeSelectionListener treeSelectionListener, PageSelectionListener pageSelectionListener) {
        this.pdfTree.addTreeSelectionListener(treeSelectionListener);
        JPopupMenu menu = PdfTreeContextMenu.getPopupMenu(this.pdfTree);
        this.pdfTree.add(menu);
        this.pdfTree.addMouseListener(new PdfTreeContextMenuMouseListener(menu, this.pdfTree));
        this.addObserver(this.pdfTree);
        this.pages = new PagesTable(this, pageSelectionListener);
        this.addObserver(this.pages);
        this.outlines = new OutlineTree(this);
        this.addObserver(this.outlines);
        this.structure = new StructureTree(this);
        this.addObserver(this.structure);
        this.form = new FormTree(this);
        this.addObserver(this.form);
        this.xref = new XRefTable(this);
        this.addObserver(this.xref);
        this.navigationTabs = new JTabbedPane();
        this.navigationTabs.addTab("Pages", null, new JScrollPane(this.pages), "Pages");
        this.navigationTabs.addTab("Outlines", null, new JScrollPane(this.outlines), "Outlines (Bookmarks)");
        this.navigationTabs.addTab("Structure", null, new JScrollPane(this.structure), "Structure tree");
        this.navigationTabs.addTab("Form", null, new JScrollPane(this.form), "Interactive Form");
        this.navigationTabs.addTab("XFA", null, new JScrollPane(this.form.getXfaTree()), "Tree view of the XFA form");
        this.navigationTabs.addTab("XRef", null, new JScrollPane(this.xref), "Cross-reference table");
        this.objectPanel = new PdfObjectPanel();
        this.addObserver(this.objectPanel);
        this.streamPane = new SyntaxHighlightedStreamPane();
        this.addObserver(this.streamPane);
        this.editorTabs = new JTabbedPane();
        this.editorTabs.addTab("Stream", null, this.streamPane, "Stream");
        this.editorTabs.addTab("XFA", null, this.form.getXfaTextArea(), "XFA Form XML file");
    }

    public PdfTree getPdfTree() {
        return this.pdfTree;
    }

    public JTabbedPane getNavigationTabs() {
        return this.navigationTabs;
    }

    public PdfObjectPanel getObjectPanel() {
        return this.objectPanel;
    }

    public JTabbedPane getEditorTabs() {
        return this.editorTabs;
    }

    public SyntaxHighlightedStreamPane getStreamPane() {
        return this.streamPane;
    }

    public void startObjectLoader(PdfFile file) {
        this.setChanged();
        this.notifyObservers();
        this.setChanged();
        new ObjectLoader(this, file.getPdfReader(), file.getFilename());
    }

    @Override
    public void notifyObservers(Object obj) {
        if (obj instanceof ObjectLoader) {
            ObjectLoader loader = (ObjectLoader)obj;
            this.nodes = loader.getNodes();
            PdfTrailerTreeNode root = this.pdfTree.getRoot();
            root.setTrailer(loader.getReader().getTrailer());
            root.setUserObject("PDF Object Tree (" + loader.getLoaderName() + ")");
            this.nodes.expandNode(root);
        }
        super.notifyObservers(obj);
    }

    public void selectNode(PdfObjectTreeNode node) {
        this.pdfTree.selectNode(node);
    }

    public void selectNode(int objectNumber) {
        this.selectNode(this.nodes.getNode(objectNumber));
    }

    public void render(PdfObject object) {
        this.objectPanel.render(object);
        this.streamPane.render(object);
        if (object instanceof PRStream) {
            this.editorTabs.setSelectedComponent(this.streamPane);
        } else {
            this.editorTabs.setSelectedIndex(this.editorTabs.getComponentCount() - 1);
        }
    }

    public void gotoPage(int pageNumber) {
        if (this.pages == null || this.pages.getSelectedRow() == --pageNumber) {
            return;
        }
        if (pageNumber < this.pages.getRowCount()) {
            this.pages.setRowSelectionInterval(pageNumber, pageNumber);
        }
    }

    @Override
    public void update(Observable observable, Object obj) {
        if ("Close".equals(obj)) {
            this.setChanged();
            this.notifyObservers(null);
            if (this.navigationTabs.indexOfTab("PlainText") != -1) {
                this.navigationTabs.removeTabAt(this.navigationTabs.indexOfTab("PlainText"));
            }
            this.nodes = null;
        }
        if (obj instanceof PdfObjectTreeNode) {
            PdfObjectTreeNode node = (PdfObjectTreeNode)obj;
            this.nodes.expandNode(node);
            if (node.isRecursive()) {
                boolean keyboardNav = false;
                KeyListener[] listeners = this.pdfTree.getKeyListeners();
                for (int i = 0; i < listeners.length; ++i) {
                    KeyListener listener = listeners[i];
                    if (!(listener instanceof PdfTreeNavigationListener)) continue;
                    keyboardNav = ((PdfTreeNavigationListener)listener).isLastActionKeyboardNavigation();
                }
                if (!keyboardNav) {
                    this.pdfTree.selectNode(node.getAncestor());
                    return;
                }
            }
            this.render(node.getPdfObject());
        }
    }

    public void addNonObserverTabs(PdfFile file) {
        if (this.navigationTabs.indexOfTab("PlainText") != -1) {
            this.navigationTabs.remove(this.navigationTabs.indexOfTab("PlainText"));
        }
        this.navigationTabs.addTab("PlainText", null, new JScrollPane(new JTextArea(file.getRawContent())), "Plain text representation of the PDF");
    }
}

